/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.SFSToSIFSConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.parsing.SFSToSIFSMigratorTest")
public class SFSToSIFSMigratorTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "testCache";

    @AfterClass
    protected void clearTempDirectory() {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
    }

    @DataProvider(name="singleFileStoreTypes")
    Object[][] singleTypes() {
        return new Object[][]{{StoreType.SINGLE_NON_SEGMENTED}, {StoreType.SINGLE_SEGMENTED}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="singleFileStoreTypes")
    public void testStoreMigration(StoreType storeType) {
        GlobalConfigurationBuilder globalConfigurationBuilder = this.globalConfiguration();
        EmbeddedCacheManager embeddedCacheManager = this.createManager(storeType, globalConfigurationBuilder);
        try {
            Cache sfsCache = embeddedCacheManager.getCache(CACHE_NAME);
            sfsCache.put((Object)"key", (Object)"value");
            TestingUtil.killCacheManagers(embeddedCacheManager);
            embeddedCacheManager = this.createManager(StoreType.MIGRATING, globalConfigurationBuilder);
            Cache sifsCache = embeddedCacheManager.getCache(CACHE_NAME);
            AssertJUnit.assertEquals((String)"value", (String)((String)sifsCache.get((Object)"key")));
            TestingUtil.killCacheManagers(embeddedCacheManager);
            embeddedCacheManager = this.createManager(StoreType.SOFT_INDEX, globalConfigurationBuilder);
            sifsCache = embeddedCacheManager.getCache(CACHE_NAME);
            AssertJUnit.assertEquals((String)"value", (String)((String)sifsCache.get((Object)"key")));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(embeddedCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(embeddedCacheManager);
    }

    private GlobalConfigurationBuilder globalConfiguration() {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()});
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().enable().persistentLocation(stateDirectory);
        return global;
    }

    private EmbeddedCacheManager createManager(StoreType storeType, GlobalConfigurationBuilder global) {
        ConfigurationBuilder config = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL);
        storeType.apply(config);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(global, new ConfigurationBuilder());
        manager.defineConfiguration(CACHE_NAME, config.build());
        return manager;
    }

    private static enum StoreType {
        SINGLE_NON_SEGMENTED{

            @Override
            void apply(ConfigurationBuilder configurationBuilder) {
                configurationBuilder.persistence().addSingleFileStore().segmented(false);
            }
        }
        ,
        SINGLE_SEGMENTED{

            @Override
            void apply(ConfigurationBuilder configurationBuilder) {
                configurationBuilder.persistence().addSingleFileStore().segmented(true);
            }
        }
        ,
        MIGRATING{

            @Override
            void apply(ConfigurationBuilder configurationBuilder) {
                configurationBuilder.persistence().addStore(SFSToSIFSConfigurationBuilder.class);
            }
        }
        ,
        SOFT_INDEX{

            @Override
            void apply(ConfigurationBuilder configurationBuilder) {
                configurationBuilder.persistence().addSoftIndexFileStore();
            }
        };


        abstract void apply(ConfigurationBuilder var1);
    }
}

