/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.threads.AbstractThreadPoolExecutorFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.jmx.CustomMBeanServerPropertiesTest;
import org.infinispan.marshall.AdvancedExternalizerTest;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jgroups.conf.ProtocolConfiguration;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.parsing.UnifiedXmlFileParsingTest")
public class UnifiedXmlFileParsingTest
extends AbstractInfinispanTest {
    public static final String TMPDIR = System.getProperty("java.io.tmpdir");

    @DataProvider(name="configurationFiles")
    public Object[][] configurationFiles() throws Exception {
        URL configDir = Thread.currentThread().getContextClassLoader().getResource("configs/all");
        List paths = Files.list(Paths.get(configDir.toURI())).collect(Collectors.toList());
        Object[][] configurationFiles = new Object[paths.size()][];
        boolean hasCurrentSchema = false;
        for (int i = 0; i < paths.size(); ++i) {
            if (((Path)paths.get(i)).getFileName().toString().equals(Version.getSchemaVersion() + ".xml")) {
                hasCurrentSchema = true;
            }
            configurationFiles[i] = new Object[]{paths.get(i)};
        }
        AssertJUnit.assertTrue((String)("Could not find a '" + Version.getSchemaVersion() + ".xml' configuration file"), (boolean)hasCurrentSchema);
        return configurationFiles;
    }

    @Test(dataProvider="configurationFiles")
    public void testParseAndConstructUnifiedXmlFile(Path config) throws IOException {
        String[] parts = config.getFileName().toString().split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        Properties properties = new Properties();
        properties.put("jboss.server.temp.dir", TMPDIR);
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), false, properties);
        URL url = FileLookupFactory.newInstance().lookupFileLocation(config.toString(), Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parse(url);
        for (ParserVersionCheck check : ParserVersionCheck.values()) {
            if (!check.isIncludedBy(major, minor)) continue;
            check.check(holder, major, minor);
        }
    }

    private static void assertTemplateConfiguration(ConfigurationBuilderHolder holder, String name) {
        Configuration configuration = UnifiedXmlFileParsingTest.getConfiguration(holder, name);
        AssertJUnit.assertNotNull((String)("Configuration " + name + " expected"), (Object)configuration);
        AssertJUnit.assertTrue((String)("Configuration " + name + " should be a template"), (boolean)configuration.isTemplate());
    }

    private static void assertCacheConfiguration(ConfigurationBuilderHolder holder, String name) {
        Configuration configuration = UnifiedXmlFileParsingTest.getConfiguration(holder, name);
        AssertJUnit.assertNotNull((String)("Configuration " + name + " expected"), (Object)configuration);
        AssertJUnit.assertFalse((String)("Configuration " + name + " should not be a template"), (boolean)configuration.isTemplate());
    }

    private static <T> T getStoreConfiguration(Configuration c, Class<T> configurationClass) {
        for (StoreConfiguration pc : c.persistence().stores()) {
            if (!configurationClass.isInstance(pc)) continue;
            return (T)pc;
        }
        throw new NoSuchElementException("There is no store of type " + configurationClass);
    }

    private static Configuration getConfiguration(ConfigurationBuilderHolder holder, String name) {
        ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
        return Objects.requireNonNull(builder).build();
    }

    private static GlobalConfiguration getGlobalConfiguration(ConfigurationBuilderHolder holder) {
        return holder.getGlobalConfigurationBuilder().build();
    }

    public static final class CustomInterceptor4
    extends BaseCustomAsyncInterceptor {
        String foo;
    }

    public static final class CustomInterceptor3
    extends BaseCustomAsyncInterceptor {
    }

    public static final class CustomInterceptor2
    extends BaseCustomAsyncInterceptor {
    }

    public static final class CustomInterceptor1
    extends BaseCustomAsyncInterceptor {
    }

    public static enum ParserVersionCheck {
        INFINISPAN_120(12, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                Configuration scattered = UnifiedXmlFileParsingTest.getConfiguration(holder, "scattered-cache");
                AssertJUnit.assertEquals((int)1, (int)scattered.clustering().invalidationBatchSize());
                AssertJUnit.assertEquals((Object)BiasAcquisition.NEVER, (Object)scattered.clustering().biasAcquisition());
                AssertJUnit.assertEquals((long)256L, (long)scattered.clustering().biasLifespan());
                TransportConfiguration tc = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).transport();
                AssertJUnit.assertTrue((tc.properties().size() >= 1 ? 1 : 0) != 0);
                AssertJUnit.assertEquals((String)"value", (String)tc.properties().getProperty("key"));
            }
        }
        ,
        INFINISPAN_110(11, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                DefaultThreadFactory threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).nonBlockingThreadPool().threadFactory();
                AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
                AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
                AssertJUnit.assertEquals((int)5, (int)threadFactory.initialPriority());
                AbstractThreadPoolExecutorFactory threadPool = (AbstractThreadPoolExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).nonBlockingThreadPool().threadPoolFactory();
                AssertJUnit.assertEquals((int)12, (int)threadPool.coreThreads());
                AssertJUnit.assertEquals((int)15, (int)threadPool.maxThreads());
                AssertJUnit.assertEquals((int)132, (int)threadPool.queueLength());
                AssertJUnit.assertEquals((long)9851L, (long)threadPool.keepAlive());
                threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).blockingThreadPool().threadFactory();
                AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
                AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
                AssertJUnit.assertEquals((int)5, (int)threadFactory.initialPriority());
                EnhancedQueueExecutorFactory blockingPool = (EnhancedQueueExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).blockingThreadPool().threadPoolFactory();
                AssertJUnit.assertEquals((int)3, (int)blockingPool.coreThreads());
                AssertJUnit.assertEquals((int)8, (int)blockingPool.maxThreads());
                AssertJUnit.assertEquals((int)121, (int)blockingPool.queueLength());
                AssertJUnit.assertEquals((long)9859L, (long)blockingPool.keepAlive());
                IndexingConfiguration indexed = UnifiedXmlFileParsingTest.getConfiguration(holder, "indexed").indexing();
                AssertJUnit.assertFalse((boolean)indexed.autoConfig());
                AssertJUnit.assertTrue((boolean)indexed.enabled());
                Set entityTypes = indexed.indexedEntityTypes();
                AssertJUnit.assertEquals((int)2, (int)entityTypes.size());
                AssertJUnit.assertTrue((boolean)entityTypes.contains("TheEntity"));
                AssertJUnit.assertTrue((boolean)entityTypes.contains("AnotherEntity"));
                Configuration minimalOffHeap = UnifiedXmlFileParsingTest.getConfiguration(holder, "minimal-offheap");
                AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)minimalOffHeap.memory().storageType());
                Configuration mediaTypeCascade = UnifiedXmlFileParsingTest.getConfiguration(holder, "media_type_cascade");
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)mediaTypeCascade.encoding().keyDataType().mediaType());
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)mediaTypeCascade.encoding().valueDataType().mediaType());
                Configuration heapBinary = UnifiedXmlFileParsingTest.getConfiguration(holder, "heap_binary");
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_PROTOSTREAM, (Object)heapBinary.encoding().keyDataType().mediaType());
                AssertJUnit.assertEquals((Object)StorageType.HEAP, (Object)heapBinary.memory().storageType());
                AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)heapBinary.memory().evictionStrategy());
                AssertJUnit.assertEquals((long)1500000000L, (long)heapBinary.memory().maxSizeBytes());
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_PROTOSTREAM, (Object)heapBinary.encoding().keyDataType().mediaType());
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_PROTOSTREAM, (Object)heapBinary.encoding().valueDataType().mediaType());
            }
        }
        ,
        INFINISPAN_100(10, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                JGroupsChannelConfigurator tcp = holder.getJGroupsStack("tcp-test");
                JGroupsChannelConfigurator mytcp = holder.getJGroupsStack("mytcp");
                AssertJUnit.assertEquals((int)tcp.getProtocolStack().size(), (int)mytcp.getProtocolStack().size());
                for (int i = 0; i < tcp.getProtocolStack().size(); ++i) {
                    ProtocolConfiguration proto1 = (ProtocolConfiguration)tcp.getProtocolStack().get(i);
                    ProtocolConfiguration proto2 = (ProtocolConfiguration)mytcp.getProtocolStack().get(i);
                    AssertJUnit.assertEquals((String)proto1.getProtocolName(), (String)proto2.getProtocolName());
                    if (proto1.getProtocolName().equals("FD_ALL") || proto1.getProtocolName().equals("FD_ALL3")) {
                        AssertJUnit.assertEquals((String)"tcp>FD_ALL>timeout", (String)"3000", (String)((String)proto1.getProperties().get("timeout")));
                        AssertJUnit.assertEquals((String)"tcp>FD_ALL>interval", (String)"1000", (String)((String)proto1.getProperties().get("interval")));
                        AssertJUnit.assertEquals((String)"mytcp>FD_ALL>timeout", (String)"3500", (String)((String)proto2.getProperties().get("timeout")));
                        AssertJUnit.assertEquals((String)"mytcp>FD_ALL>interval", (String)"1000", (String)((String)proto2.getProperties().get("interval")));
                        continue;
                    }
                    AssertJUnit.assertEquals((String)proto1.getProtocolName(), (Object)proto1.getProperties(), (Object)proto2.getProperties());
                }
                JGroupsChannelConfigurator tcpgossip = holder.getJGroupsStack("tcpgossip");
                AssertJUnit.assertEquals((int)tcp.getProtocolStack().size(), (int)tcpgossip.getProtocolStack().size());
                for (int i = 0; i < tcp.getProtocolStack().size(); ++i) {
                    ProtocolConfiguration proto1 = (ProtocolConfiguration)tcp.getProtocolStack().get(i);
                    ProtocolConfiguration proto2 = (ProtocolConfiguration)tcpgossip.getProtocolStack().get(i);
                    if (proto1.getProtocolName().equals("MPING")) {
                        AssertJUnit.assertEquals((String)"TCPGOSSIP", (String)proto2.getProtocolName());
                        continue;
                    }
                    AssertJUnit.assertEquals((String)proto1.getProtocolName(), (String)proto2.getProtocolName());
                    AssertJUnit.assertEquals((String)proto1.getProtocolName(), (Object)proto1.getProperties(), (Object)proto2.getProperties());
                }
            }
        }
        ,
        INFINISPAN_93(9, 3){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                Configuration local = UnifiedXmlFileParsingTest.getConfiguration(holder, "local");
                PersistenceConfiguration persistenceConfiguration = local.persistence();
                AssertJUnit.assertEquals((int)5, (int)persistenceConfiguration.connectionAttempts());
                AssertJUnit.assertEquals((int)100, (int)persistenceConfiguration.connectionInterval());
                AssertJUnit.assertEquals((int)2000, (int)persistenceConfiguration.availabilityInterval());
                AssertJUnit.assertFalse((boolean)persistenceConfiguration.stores().isEmpty());
                AsyncStoreConfiguration asyncConfig = ((StoreConfiguration)persistenceConfiguration.stores().iterator().next()).async();
                AssertJUnit.assertTrue((boolean)asyncConfig.failSilently());
            }
        }
        ,
        INFINISPAN_92(9, 2){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalStateConfiguration gs = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).globalState();
                AssertJUnit.assertEquals((Object)ConfigurationStorage.OVERLAY, (Object)gs.configurationStorage());
                AssertJUnit.assertEquals((String)Paths.get(TMPDIR, "sharedPath").toString(), (String)gs.sharedPersistentLocation());
                EncodingConfiguration encoding = UnifiedXmlFileParsingTest.getConfiguration(holder, "local").encoding();
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_OBJECT, (Object)encoding.keyDataType().mediaType());
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_OBJECT, (Object)encoding.valueDataType().mediaType());
                MemoryConfiguration memory = UnifiedXmlFileParsingTest.getConfiguration(holder, "dist-template").memory();
                AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)memory.evictionStrategy());
            }
        }
        ,
        INFINISPAN_91(9, 1){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                PartitionHandlingConfiguration ph = UnifiedXmlFileParsingTest.getConfiguration(holder, "dist").clustering().partitionHandling();
                AssertJUnit.assertEquals((Object)PartitionHandling.ALLOW_READS, (Object)ph.whenSplit());
                AssertJUnit.assertEquals((Object)MergePolicy.PREFERRED_NON_NULL, (Object)ph.mergePolicy());
                ph = UnifiedXmlFileParsingTest.getConfiguration(holder, "repl").clustering().partitionHandling();
                AssertJUnit.assertEquals((Object)PartitionHandling.ALLOW_READ_WRITES, (Object)ph.whenSplit());
                AssertJUnit.assertEquals((Object)MergePolicy.NONE, (Object)ph.mergePolicy());
            }
        }
        ,
        INFINISPAN_90(9, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalConfiguration globalConfiguration = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder);
                AssertJUnit.assertEquals((int)4, (int)globalConfiguration.transport().initialClusterSize());
                AssertJUnit.assertEquals((long)30000L, (long)globalConfiguration.transport().initialClusterTimeout());
                MemoryConfiguration mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "off-heap-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)mc.storageType());
                AssertJUnit.assertEquals((long)10000000L, (long)mc.size());
                AssertJUnit.assertEquals((Object)EvictionType.MEMORY, (Object)mc.evictionType());
                mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "binary-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)mc.storageType());
                AssertJUnit.assertEquals((long)1L, (long)mc.size());
                mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "object-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)mc.storageType());
            }
        }
        ,
        INFINISPAN_85(8, 5){

            @Override
            public boolean isIncludedBy(int major, int minor) {
                return major == this.major && minor >= this.minor;
            }

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalStateConfiguration gs = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).globalState();
                AssertJUnit.assertEquals((Object)ConfigurationStorage.OVERLAY, (Object)gs.configurationStorage());
                AssertJUnit.assertEquals((String)Paths.get(TMPDIR, "sharedPath").toString(), (String)gs.sharedPersistentLocation());
                EncodingConfiguration encoding = UnifiedXmlFileParsingTest.getConfiguration(holder, "local").encoding();
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_OBJECT, (Object)encoding.keyDataType().mediaType());
                AssertJUnit.assertEquals((Object)MediaType.APPLICATION_OBJECT, (Object)encoding.valueDataType().mediaType());
                PartitionHandlingConfiguration ph = UnifiedXmlFileParsingTest.getConfiguration(holder, "dist").clustering().partitionHandling();
                AssertJUnit.assertEquals((Object)PartitionHandling.ALLOW_READS, (Object)ph.whenSplit());
                AssertJUnit.assertEquals((Object)MergePolicy.PREFERRED_NON_NULL, (Object)ph.mergePolicy());
                ph = UnifiedXmlFileParsingTest.getConfiguration(holder, "repl").clustering().partitionHandling();
                AssertJUnit.assertEquals((Object)PartitionHandling.ALLOW_READ_WRITES, (Object)ph.whenSplit());
                AssertJUnit.assertEquals((Object)MergePolicy.NONE, (Object)ph.mergePolicy());
                MemoryConfiguration mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "off-heap-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)mc.storageType());
                AssertJUnit.assertEquals((long)10000000L, (long)mc.size());
                AssertJUnit.assertEquals((Object)EvictionType.MEMORY, (Object)mc.evictionType());
                mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "binary-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)mc.storageType());
                AssertJUnit.assertEquals((long)1L, (long)mc.size());
                mc = UnifiedXmlFileParsingTest.getConfiguration(holder, "object-memory").memory();
                AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)mc.storageType());
            }
        }
        ,
        INFINISPAN_84(8, 4){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
            }
        }
        ,
        INFINISPAN_83(8, 3){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
            }
        }
        ,
        INFINISPAN_82(8, 2){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalConfiguration globalConfiguration = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder);
                AssertJUnit.assertEquals((int)4, (int)globalConfiguration.transport().initialClusterSize());
                AssertJUnit.assertEquals((long)30000L, (long)globalConfiguration.transport().initialClusterTimeout());
            }
        }
        ,
        INFINISPAN_81(8, 1){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalConfiguration globalConfiguration = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder);
                AssertJUnit.assertTrue((boolean)globalConfiguration.globalState().enabled());
                AssertJUnit.assertEquals((String)Paths.get(TMPDIR, "persistentPath").toString(), (String)globalConfiguration.globalState().persistentLocation());
                AssertJUnit.assertEquals((String)Paths.get(TMPDIR, "tmpPath").toString(), (String)globalConfiguration.globalState().temporaryLocation());
            }
        }
        ,
        INFINISPAN_80(8, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                Configuration c = holder.getDefaultConfigurationBuilder().build();
                AssertJUnit.assertFalse((c.memory().evictionType() == EvictionType.MEMORY ? 1 : 0) != 0);
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "invalid");
                AssertJUnit.assertTrue((c.memory().evictionType() == EvictionType.COUNT ? 1 : 0) != 0);
                DefaultThreadFactory threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).asyncThreadPool().threadFactory();
                AssertJUnit.assertNull((Object)threadFactory);
                AbstractThreadPoolExecutorFactory threadPool = (AbstractThreadPoolExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).asyncThreadPool().threadPoolFactory();
                AssertJUnit.assertNull((Object)threadPool);
                threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).stateTransferThreadPool().threadFactory();
                AssertJUnit.assertNull((Object)threadFactory);
                threadPool = (AbstractThreadPoolExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).stateTransferThreadPool().threadPoolFactory();
                AssertJUnit.assertNull((Object)threadPool);
                UnifiedXmlFileParsingTest.assertTemplateConfiguration(holder, "local-template");
                UnifiedXmlFileParsingTest.assertTemplateConfiguration(holder, "invalidation-template");
                UnifiedXmlFileParsingTest.assertTemplateConfiguration(holder, "repl-template");
                UnifiedXmlFileParsingTest.assertTemplateConfiguration(holder, "dist-template");
                UnifiedXmlFileParsingTest.assertCacheConfiguration(holder, "local-instance");
                UnifiedXmlFileParsingTest.assertCacheConfiguration(holder, "invalidation-instance");
                UnifiedXmlFileParsingTest.assertCacheConfiguration(holder, "repl-instance");
                UnifiedXmlFileParsingTest.assertCacheConfiguration(holder, "dist-instance");
                Configuration localTemplate = UnifiedXmlFileParsingTest.getConfiguration(holder, "local-template");
                Configuration localConfiguration = UnifiedXmlFileParsingTest.getConfiguration(holder, "local-instance");
                AssertJUnit.assertEquals((long)10000L, (long)localTemplate.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)11000L, (long)localConfiguration.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)10L, (long)localTemplate.expiration().lifespan());
                AssertJUnit.assertEquals((long)10L, (long)localConfiguration.expiration().lifespan());
                Configuration replTemplate = UnifiedXmlFileParsingTest.getConfiguration(holder, "repl-template");
                Configuration replConfiguration = UnifiedXmlFileParsingTest.getConfiguration(holder, "repl-instance");
                AssertJUnit.assertEquals((long)31000L, (long)replTemplate.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((long)32000L, (long)replConfiguration.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)3000, (int)replTemplate.locking().concurrencyLevel());
                AssertJUnit.assertEquals((int)3000, (int)replConfiguration.locking().concurrencyLevel());
            }
        }
        ,
        INFINISPAN_70(7, 0){

            @Override
            public void check(ConfigurationBuilderHolder holder, int schemaMajor, int schemaMinor) {
                GlobalConfiguration g = UnifiedXmlFileParsingTest.getGlobalConfiguration(holder);
                AssertJUnit.assertEquals((String)"maximal", (String)g.cacheManagerName());
                AssertJUnit.assertTrue((boolean)g.statistics());
                AssertJUnit.assertTrue((boolean)g.jmx().enabled());
                AssertJUnit.assertEquals((String)"my-domain", (String)g.jmx().domain());
                AssertJUnit.assertTrue((boolean)(g.jmx().mbeanServerLookup() instanceof CustomMBeanServerPropertiesTest.TestLookup));
                AssertJUnit.assertEquals((int)1, (int)g.jmx().properties().size());
                AssertJUnit.assertEquals((String)"value", (String)g.jmx().properties().getProperty("key"));
                AssertJUnit.assertEquals((String)"maximal-cluster", (String)g.transport().clusterName());
                AssertJUnit.assertEquals((long)120000L, (long)g.transport().distributedSyncTimeout());
                AssertJUnit.assertNotNull((String)"udp", (Object)holder.getJGroupsStack("udp"));
                AssertJUnit.assertNotNull((String)"tcp", (Object)holder.getJGroupsStack("tcp"));
                AssertJUnit.assertEquals((Object)holder.getJGroupsStack("tcp"), (Object)g.transport().properties().get((Object)"channelConfigurator"));
                DefaultThreadFactory threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).listenerThreadPool().threadFactory();
                AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
                AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
                AssertJUnit.assertEquals((int)5, (int)threadFactory.initialPriority());
                EnhancedQueueExecutorFactory threadPool = (EnhancedQueueExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).listenerThreadPool().threadPoolFactory();
                AssertJUnit.assertEquals((int)1, (int)threadPool.coreThreads());
                AssertJUnit.assertEquals((int)1, (int)threadPool.maxThreads());
                AssertJUnit.assertEquals((int)0, (int)threadPool.queueLength());
                AssertJUnit.assertEquals((long)0L, (long)threadPool.keepAlive());
                AssertJUnit.assertTrue((boolean)(UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).expirationThreadPool().threadPoolFactory() instanceof ScheduledThreadPoolExecutorFactory));
                threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).expirationThreadPool().threadFactory();
                AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
                AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
                AssertJUnit.assertEquals((int)5, (int)threadFactory.initialPriority());
                threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).transport().remoteCommandThreadPool().threadFactory();
                AssertJUnit.assertNull((Object)threadFactory);
                threadPool = (EnhancedQueueExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).transport().remoteCommandThreadPool().threadPoolFactory();
                AssertJUnit.assertNull((Object)threadPool);
                threadFactory = (DefaultThreadFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).transport().transportThreadPool().threadFactory();
                AssertJUnit.assertNull((Object)threadFactory);
                threadPool = (EnhancedQueueExecutorFactory)UnifiedXmlFileParsingTest.getGlobalConfiguration(holder).transport().transportThreadPool().threadPoolFactory();
                AssertJUnit.assertNull((Object)threadPool);
                AssertJUnit.assertTrue((boolean)(g.serialization().marshaller() instanceof TestObjectStreamMarshaller));
                Map externalizers = g.serialization().advancedExternalizers();
                AdvancedExternalizer externalizer = (AdvancedExternalizer)externalizers.get(9001);
                AssertJUnit.assertTrue((boolean)(externalizer instanceof AdvancedExternalizerTest.IdViaConfigObj.Externalizer));
                externalizer = (AdvancedExternalizer)externalizers.get(9002);
                AssertJUnit.assertTrue((boolean)(externalizer instanceof AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer));
                AssertJUnit.assertEquals((Object)ShutdownHookBehavior.DONT_REGISTER, (Object)g.shutdown().hookBehavior());
                Configuration c = holder.getDefaultConfigurationBuilder().build();
                AssertJUnit.assertFalse((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.statistics().enabled());
                AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((long)30000L, (long)c.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)2000, (int)c.locking().concurrencyLevel());
                AssertJUnit.assertEquals((Object)IsolationLevel.NONE, (Object)c.locking().isolationLevel());
                AssertJUnit.assertTrue((boolean)c.locking().useLockStriping());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertFalse((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertTrue((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)LockingMode.OPTIMISTIC, (Object)c.transaction().lockingMode());
                AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof JBossStandaloneJTAManagerLookup));
                AssertJUnit.assertEquals((long)60000L, (long)c.transaction().cacheStopTimeout());
                AssertJUnit.assertEquals((long)20000L, (long)c.memory().size());
                AssertJUnit.assertEquals((long)10000L, (long)c.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)10L, (long)c.expiration().lifespan());
                AssertJUnit.assertEquals((long)10L, (long)c.expiration().maxIdle());
                AssertJUnit.assertFalse((boolean)c.persistence().passivation());
                StoreConfiguration fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertFalse((boolean)fileStore.fetchPersistentState());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.shared());
                AssertJUnit.assertEquals((int)2048, (int)fileStore.async().modificationQueueSize());
                AssertJUnit.assertFalse((boolean)c.indexing().enabled());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "invalid");
                AssertJUnit.assertEquals((Object)CacheMode.INVALIDATION_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.statistics().enabled());
                AssertJUnit.assertEquals((long)30500L, (long)c.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)2500, (int)c.locking().concurrencyLevel());
                AssertJUnit.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)c.locking().isolationLevel());
                AssertJUnit.assertTrue((boolean)c.locking().useLockStriping());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)LockingMode.OPTIMISTIC, (Object)c.transaction().lockingMode());
                AssertJUnit.assertEquals((long)60500L, (long)c.transaction().cacheStopTimeout());
                AssertJUnit.assertEquals((long)20500L, (long)c.memory().size());
                AssertJUnit.assertEquals((long)10500L, (long)c.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)11L, (long)c.expiration().lifespan());
                AssertJUnit.assertEquals((long)11L, (long)c.expiration().maxIdle());
                AssertJUnit.assertFalse((boolean)c.indexing().enabled());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "repl");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.statistics().enabled());
                AssertJUnit.assertEquals((long)31000L, (long)c.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)3000, (int)c.locking().concurrencyLevel());
                AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)c.locking().isolationLevel());
                AssertJUnit.assertTrue((boolean)c.locking().useLockStriping());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)LockingMode.PESSIMISTIC, (Object)c.transaction().lockingMode());
                AssertJUnit.assertEquals((long)61000L, (long)c.transaction().cacheStopTimeout());
                AssertJUnit.assertEquals((long)21000L, (long)c.memory().size());
                AssertJUnit.assertEquals((long)11000L, (long)c.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)12L, (long)c.expiration().lifespan());
                AssertJUnit.assertEquals((long)12L, (long)c.expiration().maxIdle());
                AssertJUnit.assertFalse((boolean)c.clustering().stateTransfer().fetchInMemoryState());
                AssertJUnit.assertEquals((long)60000L, (long)c.clustering().stateTransfer().timeout());
                AssertJUnit.assertEquals((int)10000, (int)c.clustering().stateTransfer().chunkSize());
                ClusterLoaderConfiguration clusterLoader = (ClusterLoaderConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, ClusterLoaderConfiguration.class);
                AssertJUnit.assertEquals((long)35000L, (long)clusterLoader.remoteCallTimeout());
                AssertJUnit.assertFalse((boolean)clusterLoader.preload());
                AssertJUnit.assertFalse((boolean)c.indexing().enabled());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "dist");
                AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertFalse((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertEquals((long)1200000L, (long)c.clustering().l1().lifespan());
                AssertJUnit.assertEquals((int)4, (int)c.clustering().hash().numOwners());
                AssertJUnit.assertEquals((long)35000L, (long)c.clustering().remoteTimeout());
                AssertJUnit.assertEquals((int)2, (int)c.clustering().hash().numSegments());
                AssertJUnit.assertTrue((boolean)(c.clustering().hash().consistentHashFactory() instanceof SyncConsistentHashFactory));
                AssertJUnit.assertTrue((boolean)c.statistics().enabled());
                AssertJUnit.assertEquals((long)31500L, (long)c.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)3500, (int)c.locking().concurrencyLevel());
                AssertJUnit.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)c.locking().isolationLevel());
                AssertJUnit.assertTrue((boolean)c.locking().useLockStriping());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertFalse((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertTrue((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)LockingMode.OPTIMISTIC, (Object)c.transaction().lockingMode());
                AssertJUnit.assertEquals((long)61500L, (long)c.transaction().cacheStopTimeout());
                AssertJUnit.assertEquals((long)21500L, (long)c.memory().size());
                AssertJUnit.assertEquals((long)11500L, (long)c.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)13L, (long)c.expiration().lifespan());
                AssertJUnit.assertEquals((long)13L, (long)c.expiration().maxIdle());
                AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().fetchInMemoryState());
                AssertJUnit.assertEquals((long)60500L, (long)c.clustering().stateTransfer().timeout());
                AssertJUnit.assertEquals((int)10500, (int)c.clustering().stateTransfer().chunkSize());
                BackupConfiguration backup = (BackupConfiguration)c.sites().allBackups().get(0);
                AssertJUnit.assertEquals((String)"NYC", (String)backup.site());
                AssertJUnit.assertEquals((Object)BackupFailurePolicy.WARN, (Object)backup.backupFailurePolicy());
                AssertJUnit.assertEquals((Object)BackupConfiguration.BackupStrategy.SYNC, (Object)backup.strategy());
                AssertJUnit.assertEquals((long)12500L, (long)backup.replicationTimeout());
                AssertJUnit.assertFalse((boolean)backup.enabled());
                backup = (BackupConfiguration)c.sites().allBackups().get(1);
                AssertJUnit.assertEquals((String)"SFO", (String)backup.site());
                AssertJUnit.assertEquals((Object)BackupFailurePolicy.IGNORE, (Object)backup.backupFailurePolicy());
                AssertJUnit.assertEquals((Object)BackupConfiguration.BackupStrategy.ASYNC, (Object)backup.strategy());
                AssertJUnit.assertEquals((long)13000L, (long)backup.replicationTimeout());
                AssertJUnit.assertTrue((boolean)backup.enabled());
                backup = (BackupConfiguration)c.sites().allBackups().get(2);
                AssertJUnit.assertEquals((String)"LON", (String)backup.site());
                AssertJUnit.assertEquals((Object)BackupFailurePolicy.FAIL, (Object)backup.backupFailurePolicy());
                AssertJUnit.assertEquals((Object)BackupConfiguration.BackupStrategy.SYNC, (Object)backup.strategy());
                AssertJUnit.assertEquals((long)13500L, (long)backup.replicationTimeout());
                AssertJUnit.assertTrue((boolean)backup.enabled());
                AssertJUnit.assertEquals((int)3, (int)backup.takeOffline().afterFailures());
                AssertJUnit.assertEquals((long)10000L, (long)backup.takeOffline().minTimeToWait());
                AssertJUnit.assertEquals((String)"users", (String)c.sites().backupFor().remoteCache());
                AssertJUnit.assertEquals((String)"LON", (String)c.sites().backupFor().remoteSite());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-data");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                StorageType objectOrDefaultStorageType = schemaMajor < 9 && schemaMinor < 5 ? StorageType.HEAP : StorageType.OBJECT;
                AssertJUnit.assertEquals((Object)objectOrDefaultStorageType, (Object)c.memory().storageType());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-metadata");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)objectOrDefaultStorageType, (Object)c.memory().storageType());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                DummyInMemoryStoreConfiguration dummyStore = (DummyInMemoryStoreConfiguration)((Object)UnifiedXmlFileParsingTest.getStoreConfiguration(c, DummyInMemoryStoreConfiguration.class));
                AssertJUnit.assertFalse((boolean)dummyStore.preload());
                AssertJUnit.assertFalse((boolean)dummyStore.purgeOnStartup());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-memcache");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)objectOrDefaultStorageType, (Object)c.memory().storageType());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                AssertJUnit.assertEquals((Object)LockingMode.PESSIMISTIC, (Object)c.transaction().lockingMode());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-default");
                AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)objectOrDefaultStorageType, (Object)c.memory().storageType());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                AssertJUnit.assertFalse((boolean)c.indexing().enabled());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-dist");
                AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((Object)objectOrDefaultStorageType, (Object)c.memory().storageType());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                AssertJUnit.assertEquals((Object)LockingMode.PESSIMISTIC, (Object)c.transaction().lockingMode());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "capedwarf-tasks");
                AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((long)10000L, (long)c.memory().size());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                AssertJUnit.assertFalse((boolean)c.indexing().enabled());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "HibernateSearch-LuceneIndexesMetadata");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "HibernateSearch-LuceneIndexesData");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                fileStore = (StoreConfiguration)UnifiedXmlFileParsingTest.getStoreConfiguration(c, this.getFileStoreClass(schemaMajor));
                AssertJUnit.assertTrue((boolean)fileStore.preload());
                AssertJUnit.assertFalse((boolean)fileStore.purgeOnStartup());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "HibernateSearch-LuceneIndexesLocking");
                AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
                AssertJUnit.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)c.transaction().transactionMode());
                AssertJUnit.assertTrue((boolean)c.invocationBatching().enabled());
                AssertJUnit.assertTrue((boolean)c.transaction().useSynchronization());
                AssertJUnit.assertFalse((boolean)c.transaction().recovery().enabled());
                AssertJUnit.assertEquals((long)-1L, (long)c.memory().size());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "custom-interceptors");
                List interceptors = c.customInterceptors().interceptors();
                InterceptorConfiguration interceptor = (InterceptorConfiguration)interceptors.get(0);
                AssertJUnit.assertTrue((boolean)(interceptor.asyncInterceptor() instanceof CustomInterceptor1));
                AssertJUnit.assertEquals(InvocationContextInterceptor.class, (Object)interceptor.after());
                interceptor = (InterceptorConfiguration)interceptors.get(1);
                AssertJUnit.assertEquals(InvocationContextInterceptor.class, (Object)interceptor.before());
                AssertJUnit.assertTrue((boolean)(interceptor.asyncInterceptor() instanceof CustomInterceptor2));
                interceptor = (InterceptorConfiguration)interceptors.get(2);
                AssertJUnit.assertTrue((boolean)(interceptor.asyncInterceptor() instanceof CustomInterceptor3));
                AssertJUnit.assertEquals((int)1, (int)interceptor.index());
                interceptor = (InterceptorConfiguration)interceptors.get(3);
                AssertJUnit.assertTrue((boolean)(interceptor.asyncInterceptor() instanceof CustomInterceptor4));
                AssertJUnit.assertEquals((Object)InterceptorConfiguration.Position.LAST, (Object)interceptor.position());
                AssertJUnit.assertTrue((boolean)c.unsafe().unreliableReturnValues());
                c = UnifiedXmlFileParsingTest.getConfiguration(holder, "write-skew");
                AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)c.locking().isolationLevel());
                if (holder.getNamedConfigurationBuilders().containsKey("store-as-binary")) {
                    c = UnifiedXmlFileParsingTest.getConfiguration(holder, "store-as-binary");
                    AssertJUnit.assertSame((Object)StorageType.BINARY, (Object)c.memory().storageType());
                }
            }
        };

        protected final int major;
        protected final int minor;

        private ParserVersionCheck(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public abstract void check(ConfigurationBuilderHolder var1, int var2, int var3);

        public boolean isIncludedBy(int major, int minor) {
            return major > this.major || major == this.major && minor >= this.minor;
        }

        Class<? extends StoreConfiguration> getFileStoreClass(int schemaMajor) {
            if (schemaMajor < 13) {
                return SingleFileStoreConfiguration.class;
            }
            return SoftIndexFileStoreConfiguration.class;
        }
    }
}

