/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="conflict.impl.MultipleCachesDuringConflictResolutionTest")
public class MultipleCachesDuringConflictResolutionTest
extends BasePartitionHandlingTest {
    private int numberOfCaches = 10;
    private int numMembersInCluster = 2;
    private BasePartitionHandlingTest.PartitionDescriptor p0 = new BasePartitionHandlingTest.PartitionDescriptor(0);
    private BasePartitionHandlingTest.PartitionDescriptor p1 = new BasePartitionHandlingTest.PartitionDescriptor(1);

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(PartitionHandling.ALLOW_READ_WRITES).mergePolicy((EntryMergePolicy)MergePolicy.PREFERRED_ALWAYS);
        String[] cacheNames = this.getCacheNames();
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gc.defaultCacheName(cacheNames[0]);
        this.createClusteredCaches(this.numMembersInCluster, gc, dcc, false, new TransportFlags().withFD(true).withMerge(true), cacheNames);
        this.waitForClusterToForm(cacheNames);
    }

    private String[] getCacheNames() {
        String[] cacheNames = new String[this.numberOfCaches];
        for (int i = 0; i < this.numberOfCaches; ++i) {
            cacheNames[i] = "cache" + i;
        }
        return cacheNames;
    }

    public void testPartitionMergePolicy() {
        TestingUtil.waitForNoRebalanceAcrossManagers(this.managers());
        log.tracef("split test", new Object[0]);
        this.splitCluster(this.p0.getNodes(), this.p1.getNodes());
        TestingUtil.waitForNoRebalanceAcrossManagers(this.manager(0));
        TestingUtil.waitForNoRebalanceAcrossManagers(this.manager(1));
        log.tracef("performMerge", new Object[0]);
        this.partition(0).merge(this.partition(1));
        TestingUtil.waitForNoRebalanceAcrossManagers(this.managers());
    }
}

