/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.impl.DefaultSegmentedDataContainerTest")
public class DefaultSegmentedDataContainerTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "dist";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builderUsed = new ConfigurationBuilder();
        builderUsed.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createClusteredCaches(3, CACHE_NAME, builderUsed);
    }

    public void ensureOldMapsRemoved() {
        for (Cache cache : this.caches(CACHE_NAME)) {
            DataContainer dc = (DataContainer)TestingUtil.extractComponent(cache, InternalDataContainer.class);
            AssertJUnit.assertEquals(DefaultSegmentedDataContainer.class, dc.getClass());
            DefaultSegmentedDataContainer segmentedDataContainer = (DefaultSegmentedDataContainer)dc;
            DistributionManager dm = TestingUtil.extractComponent(cache, DistributionManager.class);
            Address address = cache.getCacheManager().getAddress();
            Set segments = dm.getReadConsistentHash().getSegmentsForOwner(address);
            int mapCount = 0;
            for (int i = 0; i < segmentedDataContainer.maps.length(); ++i) {
                if (segmentedDataContainer.maps.get(i) == null) continue;
                AssertJUnit.assertTrue((String)("Segment " + i + " has non null map, but wasn't owned by node: " + address + "!"), (boolean)segments.contains(i));
                ++mapCount;
            }
            AssertJUnit.assertEquals((int)mapCount, (int)segments.size());
        }
    }
}

