/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.offheap.OffHeapMultiNodeTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapBoundedMultiNodeTest")
public class OffHeapBoundedMultiNodeTest
extends OffHeapMultiNodeTest {
    static final int EVICTION_SIZE = 11;
    private TransactionMode transactionMode;

    OffHeapBoundedMultiNodeTest transactionMode(TransactionMode mode) {
        this.transactionMode = mode;
        return this;
    }

    @Override
    protected Object[] parameterValues() {
        return OffHeapBoundedMultiNodeTest.concat(super.parameterValues(), this.transactionMode);
    }

    @Override
    protected String[] parameterNames() {
        return OffHeapBoundedMultiNodeTest.concat(super.parameterNames(), "transactionMode");
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapBoundedMultiNodeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        dcc.memory().storageType(StorageType.OFF_HEAP).size(11L);
        dcc.transaction().transactionMode(this.transactionMode);
        this.createCluster(dcc, 4);
        this.waitForClusterToForm();
    }

    @Override
    public Object[] factory() {
        return new Object[]{new OffHeapBoundedMultiNodeTest().transactionMode(TransactionMode.TRANSACTIONAL), new OffHeapBoundedMultiNodeTest().transactionMode(TransactionMode.NON_TRANSACTIONAL)};
    }

    public void testEviction() {
        for (int i = 0; i < 44; ++i) {
            this.cache(0).put((Object)("key" + i), (Object)("value" + i));
        }
        for (Cache cache : this.caches()) {
            int size = cache.getAdvancedCache().getDataContainer().size();
            if (size <= 11) continue;
            AssertJUnit.fail((String)("Container size was: " + size + ", it is supposed to be less than or equal to " + 11));
        }
    }
}

