/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.KeyGenerator;
import org.infinispan.container.offheap.OffHeapMultiNodeStressTest;
import org.infinispan.eviction.EvictionType;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="container.offheap.OffHeapBoundedSingleNodeStressTest")
public class OffHeapBoundedSingleNodeStressTest
extends OffHeapMultiNodeStressTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapBoundedSingleNodeStressTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        dcc.memory().storageType(StorageType.OFF_HEAP).evictionType(EvictionType.COUNT).size(500L);
        this.addClusterEnabledCacheManager(dcc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfWrites() throws Exception {
        int WRITE_THREADS = 5;
        int INSERTIONCOUNT = 1000000;
        int KEY_SIZE = 30;
        ExecutorService execService = Executors.newFixedThreadPool(5, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(execService);
        try {
            int i;
            Cache map = this.cache(0);
            for (i = 0; i < 5; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 1000000; ++j) {
                        byte[] key = this.randomBytes(30);
                        byte[] value = this.randomBytes(j / 100);
                        map.put(key, value);
                        if (j % 1000 != 0) continue;
                        log.debugf("%d entries written", j);
                    }
                    return null;
                });
            }
            for (i = 0; i < 5; ++i) {
                Future future = service.poll(1000L, TimeUnit.SECONDS);
                if (future == null) {
                    throw new TimeoutException();
                }
                future.get();
            }
        }
        finally {
            execService.shutdown();
            execService.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfPutsAndReadsIntoDataContainer() throws InterruptedException, ExecutionException {
        int WRITE_THREADS = 4;
        int READ_THREADS = 16;
        ExecutorService execService = Executors.newFixedThreadPool(WRITE_THREADS + READ_THREADS, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(execService);
        try {
            int i;
            Cache cache = this.cache(0);
            DataContainer map = cache.getAdvancedCache().getDataContainer();
            for (i = 0; i < WRITE_THREADS; ++i) {
                service.submit(() -> {
                    KeyGenerator generator = new KeyGenerator();
                    while (!Thread.interrupted()) {
                        WrappedByteArray key = generator.getNextKey();
                        WrappedByteArray value = generator.getNextValue();
                        map.put((Object)key, (Object)value, generator.getMetadata());
                    }
                    return null;
                });
            }
            for (i = 0; i < READ_THREADS; ++i) {
                service.submit(() -> {
                    KeyGenerator generator = new KeyGenerator();
                    while (!Thread.interrupted()) {
                        WrappedByteArray key = generator.getNextKey();
                        InternalCacheEntry innerV = map.get((Object)key);
                        if (innerV == null || !innerV.equals(cache)) continue;
                        System.out.println(System.currentTimeMillis());
                    }
                    return null;
                });
            }
            Future future = service.poll(30L, TimeUnit.SECONDS);
            if (future != null) {
                future.get();
            }
        }
        finally {
            execService.shutdownNow();
            execService.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }
}

