/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.offheap.OffHeapSingleNodeTest;
import org.infinispan.eviction.EvictionType;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapBoundedSingleNodeTest")
public class OffHeapBoundedSingleNodeTest
extends OffHeapSingleNodeTest {
    private static final int COUNT = 51;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapBoundedSingleNodeTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        dcc.memory().storageType(StorageType.OFF_HEAP).size(51L).evictionType(EvictionType.COUNT);
        dcc.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.addClusterEnabledCacheManager(dcc);
        this.configureTimeService();
    }

    public void testMoreWriteThanSize() {
        Cache cache = this.cache(0);
        for (int i = 0; i < 56; ++i) {
            cache.put((Object)("key" + i), (Object)("value" + i));
        }
        AssertJUnit.assertEquals((int)51, (int)cache.size());
    }

    public void testMultiThreaded() throws ExecutionException, InterruptedException, TimeoutException {
        Cache cache = this.cache(0);
        AtomicInteger offset = new AtomicInteger();
        AtomicBoolean collision = new AtomicBoolean();
        int threadCount = 5;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            futures.add(this.fork(() -> {
                boolean collide = collision.get();
                collision.set(!collide);
                int value = collide ? offset.get() : offset.incrementAndGet();
                for (int j = 0; j < 56; ++j) {
                    if (Thread.interrupted()) {
                        log.tracef("Test was ordered to stop!", new Object[0]);
                        return;
                    }
                    String key = "key" + value + "-" + j;
                    cache.put((Object)key, (Object)("value" + value + "-" + j));
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                futures.forEach(f -> f.cancel(true));
                throw e;
            }
        }
        int cacheSize = cache.size();
        if (cacheSize > 51) {
            log.fatal((Object)("Entries were: " + (String)cache.entrySet().stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        AssertJUnit.assertTrue((String)("Cache size was " + cacheSize), (cacheSize <= 51 ? 1 : 0) != 0);
    }
}

