/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapEntryFactoryImpl;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="container.offheap.OffHeapConcurrentMapTest")
public class OffHeapConcurrentMapTest {
    private OffHeapConcurrentMap map;
    private WrappedByteArray valueByteArray = new WrappedByteArray(new byte[]{0, 1, 2, 3, 4, 5});
    private static final int RESIZE_LIMITATION = OffHeapConcurrentMap.computeThreshold((int)256);

    @BeforeMethod
    void initializeMap() {
        UnpooledOffHeapMemoryAllocator allocator = new UnpooledOffHeapMemoryAllocator();
        OffHeapEntryFactoryImpl offHeapEntryFactory = new OffHeapEntryFactoryImpl();
        offHeapEntryFactory.allocator = allocator;
        offHeapEntryFactory.internalEntryFactory = new InternalEntryFactoryImpl();
        offHeapEntryFactory.configuration = new ConfigurationBuilder().build();
        offHeapEntryFactory.start();
        this.map = new OffHeapConcurrentMap((OffHeapMemoryAllocator)allocator, (OffHeapEntryFactory)offHeapEntryFactory, null);
    }

    @AfterMethod
    void afterMethod() {
        if (this.map != null) {
            this.map.close();
        }
    }

    private Set<WrappedBytes> insertUpToResizeLimitation() {
        HashSet<WrappedBytes> keys = new HashSet<WrappedBytes>();
        for (int i = 0; i < RESIZE_LIMITATION - 1; ++i) {
            AssertJUnit.assertTrue((boolean)keys.add(this.putInMap(this.map, (WrappedBytes)this.valueByteArray)));
        }
        return keys;
    }

    public void testIterationStartedWithResize1() {
        Set<WrappedBytes> expectedKeys = this.insertUpToResizeLimitation();
        HashSet<WrappedBytes> results = new HashSet<WrappedBytes>();
        Iterator iterator = this.map.values().iterator();
        AssertJUnit.assertTrue((boolean)iterator.hasNext());
        AssertJUnit.assertTrue((boolean)results.add((WrappedBytes)((InternalCacheEntry)iterator.next()).getKey()));
        this.putInMap(this.map, (WrappedBytes)this.valueByteArray);
        while (iterator.hasNext()) {
            AssertJUnit.assertTrue((boolean)results.add((WrappedBytes)((InternalCacheEntry)iterator.next()).getKey()));
        }
        for (WrappedBytes expected : expectedKeys) {
            AssertJUnit.assertTrue((String)("Results didn't contain: " + expected), (boolean)results.contains(expected));
        }
    }

    public void testIterationStartedWithTwoResizes() {
        Set<WrappedBytes> expectedKeys = this.insertUpToResizeLimitation();
        HashSet<Object> results = new HashSet<Object>();
        Iterator iterator = this.map.values().iterator();
        AssertJUnit.assertTrue((boolean)iterator.hasNext());
        AssertJUnit.assertTrue((boolean)results.add(((InternalCacheEntry)iterator.next()).getKey()));
        for (int i = 0; i < RESIZE_LIMITATION + 2; ++i) {
            this.putInMap(this.map, (WrappedBytes)this.valueByteArray);
        }
        while (iterator.hasNext()) {
            AssertJUnit.assertTrue((boolean)results.add(((InternalCacheEntry)iterator.next()).getKey()));
        }
        for (WrappedBytes expected : expectedKeys) {
            AssertJUnit.assertTrue((String)("Results didn't contain: " + expected), (boolean)results.contains(expected));
        }
    }

    public void testIterationAfterAResize() {
        this.insertUpToResizeLimitation();
        this.putInMap(this.map, (WrappedBytes)this.valueByteArray);
        int entriesFound = 0;
        for (InternalCacheEntry value : this.map.values()) {
            ++entriesFound;
        }
        AssertJUnit.assertEquals((int)RESIZE_LIMITATION, (int)entriesFound);
    }

    public void testIterationCreatedButNotUsedUntilAfterAResize() {
        this.insertUpToResizeLimitation();
        Iterator iter = this.map.values().iterator();
        this.putInMap(this.map, (WrappedBytes)this.valueByteArray);
        int entriesFound = 0;
        while (iter.hasNext()) {
            InternalCacheEntry ice = (InternalCacheEntry)iter.next();
            AssertJUnit.assertNotNull((Object)ice);
            ++entriesFound;
        }
        AssertJUnit.assertEquals((int)RESIZE_LIMITATION, (int)entriesFound);
    }

    WrappedBytes putInMap(OffHeapConcurrentMap map, WrappedBytes value) {
        WrappedBytes key;
        InternalCacheEntry ice;
        while ((ice = map.put(key = this.randomBytes(), (InternalCacheEntry)new ImmortalCacheEntry((Object)key, (Object)value))) != null) {
        }
        return key;
    }

    WrappedBytes randomBytes() {
        byte[] randomBytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        return new WrappedByteArray(randomBytes);
    }
}

