/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="container.offheap.OffHeapMultiNodeStressTest", timeOut=900000L)
public class OffHeapMultiNodeStressTest
extends MultipleCacheManagersTest {
    static final int KEY_SIZE = 20;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapMultiNodeStressTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        dcc.memory().storageType(StorageType.OFF_HEAP);
        this.createCluster(dcc, 4);
        this.waitForClusterToForm();
    }

    static DataContainer<WrappedByteArray, WrappedByteArray> castDC(Object obj) {
        return (DataContainer)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfWritesAndFewRemoves() throws Exception {
        int WRITE_THREADS = 5;
        int REMOVE_THREADS = 2;
        int INSERTIONCOUNT = 2048;
        boolean REMOVECOUNT = true;
        ExecutorService execService = Executors.newFixedThreadPool(7, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(execService);
        try {
            int i;
            Cache map = this.cache(0);
            for (i = 0; i < 5; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 2048; ++j) {
                        byte[] hcc = this.randomBytes(20);
                        map.put(hcc, hcc);
                    }
                    return null;
                });
            }
            for (i = 0; i < 2; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 1; ++j) {
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            map.remove(iterator.next().getKey());
                        }
                    }
                    return null;
                });
            }
            for (i = 0; i < 7; ++i) {
                Future future = service.poll(10L, TimeUnit.SECONDS);
                if (future == null) {
                    throw new TimeoutException();
                }
                future.get();
            }
        }
        finally {
            execService.shutdown();
            execService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWritesAndRemovesWithExecutes() throws Exception {
        int WRITE_THREADS = 5;
        int REMOVE_THREADS = 2;
        int EXECUTE_THREADS = 2;
        int INSERTIONCOUNT = 2048;
        boolean REMOVECOUNT = true;
        int EXECUTECOUNT = 2;
        ExecutorService execService = Executors.newFixedThreadPool(9, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(execService);
        try {
            int i;
            Cache bchm = this.cache(0);
            for (i = 0; i < 5; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 2048; ++j) {
                        byte[] hcc = this.randomBytes(20);
                        bchm.put((Object)hcc, (Object)hcc);
                    }
                    return null;
                });
            }
            for (i = 0; i < 2; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 1; ++j) {
                        CloseableIterator iterator = bchm.entrySet().iterator();
                        while (iterator.hasNext()) {
                            bchm.remove(((Map.Entry)iterator.next()).getKey());
                        }
                    }
                    return null;
                });
            }
            for (i = 0; i < 2; ++i) {
                service.submit(() -> {
                    for (int j = 0; j < 2; ++j) {
                        DataContainer<WrappedByteArray, WrappedByteArray> container = OffHeapMultiNodeStressTest.castDC(bchm.getAdvancedCache().getDataContainer());
                        container.forEach(ice -> AssertJUnit.assertEquals((Object)ice, (Object)container.get(ice.getKey())));
                    }
                    return null;
                });
            }
            for (i = 0; i < 9; ++i) {
                Future future = service.poll(10L, TimeUnit.SECONDS);
                if (future == null) {
                    throw new TimeoutException();
                }
                future.get();
            }
        }
        finally {
            execService.shutdown();
            execService.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

