/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.OffHeapSingleNodeTest;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapSingleNodeExpirationEvictionTest")
public class OffHeapSingleNodeExpirationEvictionTest
extends OffHeapSingleNodeTest {
    private EXPIRE_TYPE expirationType;
    private boolean eviction;

    private OffHeapSingleNodeExpirationEvictionTest expirationTest(EXPIRE_TYPE expirationType) {
        this.expirationType = expirationType;
        return this;
    }

    private OffHeapSingleNodeExpirationEvictionTest eviction(boolean enable) {
        this.eviction = enable;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return OffHeapSingleNodeExpirationEvictionTest.concat(super.parameterNames(), "EXPIRE_TYPE", "eviction");
    }

    @Override
    protected Object[] parameterValues() {
        return OffHeapSingleNodeExpirationEvictionTest.concat(super.parameterValues(), new Object[]{this.expirationType, this.eviction});
    }

    @Override
    public Object[] factory() {
        return new Object[]{new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.MORTAL).eviction(true), new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.MORTAL).eviction(false), new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.TRANSIENT).eviction(true), new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.TRANSIENT).eviction(false), new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.TRANSIENT_MORTAL).eviction(true), new OffHeapSingleNodeExpirationEvictionTest().expirationTest(EXPIRE_TYPE.TRANSIENT_MORTAL).eviction(false)};
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder defaultConfig) {
        switch (this.expirationType) {
            case MORTAL: {
                defaultConfig.expiration().lifespan(10L, TimeUnit.MINUTES);
                break;
            }
            case TRANSIENT: {
                defaultConfig.expiration().maxIdle(10L, TimeUnit.MINUTES);
                break;
            }
            case TRANSIENT_MORTAL: {
                defaultConfig.expiration().lifespan(10L, TimeUnit.MINUTES).maxIdle(10L, TimeUnit.MINUTES);
            }
        }
        if (this.eviction) {
            defaultConfig.memory().evictionType(EvictionType.COUNT).size(1000L);
        }
        return super.addClusterEnabledCacheManager(defaultConfig);
    }

    public void testEnsureCorrectStorage() {
        Cache cache = this.cache(0);
        long beforeInsert = this.timeService.wallClockTime();
        cache.put((Object)"k", (Object)"v");
        this.timeService.advance(10L);
        DataConversion dataConversion = cache.getAdvancedCache().getKeyDataConversion();
        Object convertedKey = dataConversion.toStorage((Object)"k");
        AssertJUnit.assertNotNull((Object)cache.getAdvancedCache().getDataContainer().get(convertedKey));
        InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(convertedKey);
        AssertJUnit.assertNotNull((Object)entry);
        long storedTime = TimeUnit.MINUTES.toMillis(10L);
        switch (this.expirationType) {
            case MORTAL: {
                AssertJUnit.assertEquals((long)storedTime, (long)entry.getLifespan());
                AssertJUnit.assertEquals((long)-1L, (long)entry.getMaxIdle());
                AssertJUnit.assertEquals((long)beforeInsert, (long)entry.getCreated());
                AssertJUnit.assertEquals((long)-1L, (long)entry.getLastUsed());
                break;
            }
            case TRANSIENT: {
                AssertJUnit.assertEquals((long)-1L, (long)entry.getLifespan());
                AssertJUnit.assertEquals((long)storedTime, (long)entry.getMaxIdle());
                AssertJUnit.assertEquals((long)-1L, (long)entry.getCreated());
                AssertJUnit.assertEquals((long)beforeInsert, (long)entry.getLastUsed());
                break;
            }
            case TRANSIENT_MORTAL: {
                AssertJUnit.assertEquals((long)storedTime, (long)entry.getLifespan());
                AssertJUnit.assertEquals((long)storedTime, (long)entry.getMaxIdle());
                AssertJUnit.assertEquals((long)beforeInsert, (long)entry.getCreated());
                AssertJUnit.assertEquals((long)beforeInsert, (long)entry.getLastUsed());
            }
        }
    }

    private static enum EXPIRE_TYPE {
        MORTAL,
        TRANSIENT,
        TRANSIENT_MORTAL;

    }
}

