/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.MemoryUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.impl.KeyValueMetadataSizeCalculator;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapSizeTest")
public class OffHeapSizeTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(StorageType.OFF_HEAP).size(MemoryUnit.MEGABYTES.toBytes(10L)).evictionType(EvictionType.MEMORY).evictionStrategy(EvictionStrategy.EXCEPTION).transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    @DataProvider(name="sizeMatchData")
    public Object[][] sizeMatchData() {
        return new Object[][]{{10, 100, -1, -1, null}, {20, 313, -1, -1, null}, {10, 100, 4000, -1, null}, {20, 313, -1, 10000, null}, {10, 100, 4000, -1, new NumericVersion(1003L)}, {20, 313, -1, 10000, new NumericVersion(81418L)}, {10, 100, 4000, 738141, null}, {20, 313, 14141, 10000, new NumericVersion(8417L)}};
    }

    @Test(dataProvider="sizeMatchData")
    public void testSizeMatch(int keyLength, int valueLength, long maxIdle, long lifespan, EntryVersion version) {
        OffHeapMemoryAllocator allocator = TestingUtil.extractComponent(this.cache, OffHeapMemoryAllocator.class);
        long beginningSize = allocator.getAllocatedAmount();
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        byte[] keyBytes = new byte[keyLength];
        byte[] valueBytes = new byte[valueLength];
        threadLocalRandom.nextBytes(keyBytes);
        threadLocalRandom.nextBytes(valueBytes);
        WrappedByteArray key = new WrappedByteArray(keyBytes);
        WrappedByteArray value = new WrappedByteArray(valueBytes);
        EmbeddedMetadata.Builder metadataBuilder = new EmbeddedMetadata.Builder();
        if (maxIdle >= 0L) {
            metadataBuilder.maxIdle(maxIdle);
        }
        if (lifespan >= 0L) {
            metadataBuilder.lifespan(lifespan);
        }
        if (version != null) {
            metadataBuilder.version(version);
        }
        Metadata metadata = metadataBuilder.build();
        KeyValueMetadataSizeCalculator calculator = TestingUtil.extractComponent(this.cache, KeyValueMetadataSizeCalculator.class);
        long estimateSize = calculator.calculateSize((Object)key, (Object)value, metadata);
        this.cache.getAdvancedCache().getDataContainer().put((Object)key, (Object)value, metadata);
        long endingSize = allocator.getAllocatedAmount();
        AssertJUnit.assertEquals((long)(endingSize - beginningSize), (long)estimateSize);
    }
}

