/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.AbstractClusteredWriteSkewTest", groups={"functional"})
public abstract class AbstractClusteredWriteSkewTest
extends MultipleCacheManagersTest {
    private static final String PASSIVATION_CACHE = "passivation-cache";
    private static final int MAX_ENTRIES = 2;

    public final void testPutIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.PUT, false);
    }

    public final void testPutIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.PUT, false);
    }

    public final void testPutIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.PUT, true);
    }

    public final void testPutIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.PUT, true);
    }

    public final void testRemoveIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.REMOVE, false);
    }

    public final void testRemoveIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.REMOVE, false);
    }

    public final void testRemoveIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.REMOVE, true);
    }

    public final void testRemoveIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.REMOVE, true);
    }

    public final void testReplaceIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.REPLACE, false);
    }

    public final void testReplaceIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.REPLACE, false);
    }

    public final void testReplaceIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.REPLACE, true);
    }

    public final void testReplaceIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.REPLACE, true);
    }

    public final void testPutIfAbsentIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_PUT, false);
    }

    public final void testPutIfAbsentIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_PUT, false);
    }

    public final void testPutIfAbsentIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_PUT, true);
    }

    public final void testPutIfAbsentIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_PUT, true);
    }

    public final void testConditionalRemoveIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_REMOVE, false);
    }

    public final void testConditionalRemoveIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_REMOVE, false);
    }

    public final void testConditionalRemoveIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_REMOVE, true);
    }

    public final void testConditionalRemoveIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_REMOVE, true);
    }

    public final void testConditionalReplaceIgnoreReturnValueOnNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_REPLACE, false);
    }

    public final void testConditionalReplaceIgnoreReturnValueOnNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_REPLACE, false);
    }

    public final void testConditionalReplaceIgnoreReturnValueNonExistingKey() throws Exception {
        this.doIgnoreReturnValueTest(true, Operation.CONDITIONAL_REPLACE, true);
    }

    public final void testConditionalReplaceIgnoreReturnValueNonExistingKeyOnNonOwner() throws Exception {
        this.doIgnoreReturnValueTest(false, Operation.CONDITIONAL_REPLACE, true);
    }

    public final void testPutWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.PUT, false);
    }

    public final void testPutFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.PUT, true);
    }

    public final void testPutWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.PUT, false);
    }

    public final void testPutFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.PUT, true);
    }

    public final void testRemoveWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.REMOVE, false);
    }

    public final void testRemoveFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.REMOVE, true);
    }

    public final void testRemoveWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.REMOVE, false);
    }

    public final void testRemoveFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.REMOVE, true);
    }

    public final void testReplaceWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.REPLACE, false);
    }

    public final void testReplaceFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.REPLACE, true);
    }

    public final void testReplaceWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.REPLACE, false);
    }

    public final void testReplaceFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.REPLACE, true);
    }

    public final void testConditionalPutWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_PUT, false);
    }

    public final void testConditionalPutFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_PUT, true);
    }

    public final void testConditionalPutWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_PUT, false);
    }

    public final void testConditionalPutFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_PUT, true);
    }

    public final void testConditionalRemoveWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_REMOVE, false);
    }

    public final void testConditionalRemoveFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_REMOVE, true);
    }

    public final void testConditionalRemoveWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_REMOVE, false);
    }

    public final void testConditionalRemoveFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_REMOVE, true);
    }

    public final void testConditionalReplaceWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_REPLACE, false);
    }

    public final void testConditionalReplaceFailWriteSkewWithPassivation() throws Exception {
        this.doTestWriteSkewWithPassivation(true, Operation.CONDITIONAL_REPLACE, true);
    }

    public final void testConditionalReplaceWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_REPLACE, false);
    }

    public final void testConditionalReplaceFailWriteSkewWithPassivationOnNonOwner() throws Exception {
        this.doTestWriteSkewWithPassivation(false, Operation.CONDITIONAL_REPLACE, true);
    }

    public final void testIgnorePreviousValueAndReadOnPrimary() throws Exception {
        this.doTestIgnoreReturnValueAndRead(false);
    }

    public final void testIgnorePreviousValueAndReadOnNonOwner() throws Exception {
        this.doTestIgnoreReturnValueAndRead(true);
    }

    protected void doTestIgnoreReturnValueAndRead(boolean executeOnPrimaryOwner) throws Exception {
        MagicKey key = new MagicKey("ignore-previous-value", this.cache(0));
        AdvancedCache c = executeOnPrimaryOwner ? this.advancedCache(0) : this.advancedCache(1);
        TransactionManager tm = executeOnPrimaryOwner ? this.tm(0) : this.tm(1);
        for (Cache cache : this.caches()) {
            AssertJUnit.assertNull((String)("wrong initial value for " + this.address(cache) + "."), (Object)cache.get((Object)key));
        }
        c.put((Object)"k", (Object)"init");
        tm.begin();
        c.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)"k", (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)c.put((Object)"k", (Object)"v2"));
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals((Object)"init", (Object)c.put((Object)"k", (Object)"other"));
        tm.resume(tx);
        tm.commit();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = this.defaultConfigurationBuilder();
        this.decorate(builder);
        this.createCluster(TestDataSCI.INSTANCE, builder, this.clusterSize());
        this.waitForClusterToForm();
        builder = this.defaultConfigurationBuilder();
        builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        builder.memory().size(2L);
        this.decorate(builder);
        this.defineConfigurationOnAllManagers(PASSIVATION_CACHE, builder);
        this.waitForClusterToForm(PASSIVATION_CACHE);
    }

    protected void decorate(ConfigurationBuilder builder) {
    }

    protected abstract CacheMode getCacheMode();

    protected abstract int clusterSize();

    private void doTestWriteSkewWithPassivation(boolean executeOnPrimaryOwner, Operation operation, boolean fail) throws Exception {
        String finalValue;
        MagicKey key;
        block20: {
            AdvancedCache primaryOwner = this.advancedCache(0, PASSIVATION_CACHE);
            key = new MagicKey("ignore-return-value", (Cache<?, ?>)primaryOwner);
            AdvancedCache executeOnCache = executeOnPrimaryOwner ? this.advancedCache(0, PASSIVATION_CACHE) : this.advancedCache(1, PASSIVATION_CACHE);
            TransactionManager tm = executeOnPrimaryOwner ? this.tm(0, PASSIVATION_CACHE) : this.tm(1, PASSIVATION_CACHE);
            for (Cache cache : this.caches(PASSIVATION_CACHE)) {
                AssertJUnit.assertNull((String)("wrong initial value for " + this.address(cache) + "."), (Object)cache.get((Object)key));
            }
            switch (operation) {
                case CONDITIONAL_REMOVE: 
                case CONDITIONAL_REPLACE: 
                case REPLACE: {
                    log.debug((Object)"Initialize key");
                    primaryOwner.put((Object)key, (Object)"init");
                }
            }
            log.debugf("Start the transaction and perform a %s operation", (Object)operation);
            tm.begin();
            switch (operation) {
                case PUT: {
                    executeOnCache.put((Object)key, (Object)"v1");
                    break;
                }
                case REMOVE: {
                    executeOnCache.remove((Object)key);
                    break;
                }
                case REPLACE: {
                    executeOnCache.replace((Object)key, (Object)"v1");
                    break;
                }
                case CONDITIONAL_PUT: {
                    executeOnCache.putIfAbsent((Object)key, (Object)"v1");
                    break;
                }
                case CONDITIONAL_REMOVE: {
                    AssertJUnit.assertTrue((boolean)executeOnCache.remove((Object)key, (Object)"init"));
                    break;
                }
                case CONDITIONAL_REPLACE: {
                    AssertJUnit.assertTrue((boolean)executeOnCache.replace((Object)key, (Object)"init", (Object)"v1"));
                    break;
                }
                default: {
                    tm.rollback();
                    AssertJUnit.fail((String)("Unknown operation " + (Object)((Object)operation)));
                }
            }
            Transaction tx = tm.suspend();
            if (fail) {
                primaryOwner.put((Object)key, (Object)"v2");
            }
            primaryOwner.evict((Object)key);
            log.debugf("It is going to try to commit the suspended transaction", new Object[0]);
            try {
                tm.resume(tx);
                tm.commit();
                if (fail) {
                    AssertJUnit.fail((String)"Rollback expected!");
                }
            }
            catch (HeuristicRollbackException | RollbackException e) {
                if (fail) break block20;
                AssertJUnit.fail((String)"Rollback *not* expected!");
            }
        }
        switch (operation) {
            case CONDITIONAL_REMOVE: 
            case REMOVE: {
                finalValue = fail ? "v2" : null;
                break;
            }
            default: {
                finalValue = fail ? "v2" : "v1";
            }
        }
        log.debugf("So far so good. Check the key final value", new Object[0]);
        this.assertNoTransactions();
        for (Cache cache : this.caches(PASSIVATION_CACHE)) {
            AssertJUnit.assertEquals((String)("wrong final value for " + this.address(cache) + "."), (Object)finalValue, (Object)cache.get((Object)key));
        }
    }

    private ConfigurationBuilder defaultConfigurationBuilder() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(this.getCacheMode()).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).transaction().lockingMode(LockingMode.OPTIMISTIC);
        return builder;
    }

    private void doIgnoreReturnValueTest(boolean executeOnPrimaryOwner, Operation operation, boolean initKey) throws Exception {
        String finalValue;
        MagicKey key;
        block15: {
            key = new MagicKey("ignore-return-value", this.cache(0));
            AdvancedCache c = executeOnPrimaryOwner ? this.advancedCache(0) : this.advancedCache(1);
            TransactionManager tm = executeOnPrimaryOwner ? this.tm(0) : this.tm(1);
            for (Cache cache : this.caches()) {
                AssertJUnit.assertNull((String)("wrong initial value for " + this.address(cache) + "."), (Object)cache.get((Object)key));
            }
            log.debugf("Initialize the key? %s", (Object)initKey);
            if (initKey) {
                this.cache(0).put((Object)key, (Object)"init");
            }
            finalValue = null;
            boolean rollbackExpected = false;
            log.debugf("Start the transaction and perform a %s operation", (Object)operation);
            tm.begin();
            switch (operation) {
                case PUT: {
                    finalValue = "v1";
                    rollbackExpected = false;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)key, (Object)"v1");
                    break;
                }
                case REMOVE: {
                    finalValue = null;
                    rollbackExpected = false;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).remove((Object)key);
                    break;
                }
                case REPLACE: {
                    finalValue = "v2";
                    rollbackExpected = initKey;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).replace((Object)key, (Object)"v1");
                    break;
                }
                case CONDITIONAL_PUT: {
                    finalValue = "v2";
                    rollbackExpected = !initKey;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).putIfAbsent((Object)key, (Object)"v1");
                    break;
                }
                case CONDITIONAL_REMOVE: {
                    finalValue = "v2";
                    rollbackExpected = initKey;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).remove((Object)key, (Object)"init");
                    break;
                }
                case CONDITIONAL_REPLACE: {
                    finalValue = "v2";
                    rollbackExpected = initKey;
                    c.withFlags(Flag.IGNORE_RETURN_VALUES).replace((Object)key, (Object)"init", (Object)"v1");
                    break;
                }
                default: {
                    tm.rollback();
                    AssertJUnit.fail((String)("Unknown operation " + (Object)((Object)operation)));
                }
            }
            Transaction tx = tm.suspend();
            log.debugf("Suspend the transaction and update the key", new Object[0]);
            c.put((Object)key, (Object)"v2");
            log.debugf("Checking if all the keys has the same value", new Object[0]);
            for (Cache cache : this.caches()) {
                AssertJUnit.assertEquals((String)("wrong intermediate value for " + this.address(cache) + "."), (Object)"v2", (Object)cache.get((Object)key));
            }
            log.debugf("It is going to try to commit the suspended transaction", new Object[0]);
            try {
                tm.resume(tx);
                tm.commit();
                if (rollbackExpected) {
                    AssertJUnit.fail((String)"Rollback expected!");
                }
            }
            catch (HeuristicRollbackException | RollbackException e) {
                if (rollbackExpected) break block15;
                AssertJUnit.fail((String)"Rollback *not* expected!");
            }
        }
        log.debugf("So far so good. Check the key final value", new Object[0]);
        this.assertNoTransactions();
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)("wrong final value for " + this.address(cache) + "."), (Object)finalValue, (Object)cache.get((Object)key));
        }
    }

    private static enum Operation {
        PUT,
        REMOVE,
        REPLACE,
        CONDITIONAL_PUT,
        CONDITIONAL_REMOVE,
        CONDITIONAL_REPLACE;

    }
}

