/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.Arrays;
import java.util.List;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.remoting.transport.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.versioning.NumericVersionGeneratorTest")
public class NumericVersionGeneratorTest {
    public void testGenerateVersion() {
        NumericVersionGenerator vg = new NumericVersionGenerator().clustered(true);
        vg.resetCounter();
        TestAddress addr1 = new TestAddress(1);
        TestAddress addr2 = new TestAddress(2);
        TestAddress addr3 = new TestAddress(1);
        List<Address> members = Arrays.asList(addr1, addr2, addr3);
        vg.calculateRank((Address)addr2, members, 1L);
        AssertJUnit.assertEquals((Object)new NumericVersion(0x1000200000001L), (Object)vg.generateNew());
        AssertJUnit.assertEquals((Object)new NumericVersion(0x1000200000002L), (Object)vg.generateNew());
        AssertJUnit.assertEquals((Object)new NumericVersion(281483566645251L), (Object)vg.generateNew());
    }

    class TestAddress
    implements Address {
        int addressNum;

        TestAddress(int addressNum) {
            this.addressNum = addressNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TestAddress that = (TestAddress)o;
            return this.addressNum == that.addressNum;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.addressNum;
            return result;
        }

        public int compareTo(Address o) {
            TestAddress oa = (TestAddress)o;
            return this.addressNum - oa.addressNum;
        }
    }
}

