/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.versioning.SimpleConditionalOperationsWriteSkewTest")
public class SimpleConditionalOperationsWriteSkewTest
extends MultipleCacheManagersTest {
    protected ConfigurationBuilder getConfig() {
        ConfigurationBuilder dcc = SimpleConditionalOperationsWriteSkewTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.transaction().locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return dcc;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, this.getConfig(), 2);
        this.waitForClusterToForm();
    }

    public void testReplaceFromMainOwner() throws Throwable {
        Object k = this.getKeyForCache(0);
        this.cache(0).put(k, (Object)"0");
        this.tm(0).begin();
        this.cache(0).put((Object)"kkk", (Object)"vvv");
        this.cache(0).replace(k, (Object)"v1", (Object)"v2");
        this.tm(0).commit();
        Assert.assertEquals((Object)this.advancedCache(0).getDataContainer().get(k).getValue(), (Object)"0");
        Assert.assertEquals((Object)this.advancedCache(1).getDataContainer().get(k).getValue(), (Object)"0");
        log.trace((Object)"here is the interesting replace.");
        this.cache(0).replace(k, (Object)"0", (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(0).getDataContainer().get(k).getValue(), (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(1).getDataContainer().get(k).getValue(), (Object)"1");
    }

    public void testRemoveFromMainOwner() {
        Object k = this.getKeyForCache(0);
        this.cache(0).put(k, (Object)"0");
        this.cache(0).remove(k, (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(0).getDataContainer().get(k).getValue(), (Object)"0");
        Assert.assertEquals((Object)this.advancedCache(1).getDataContainer().get(k).getValue(), (Object)"0");
        this.cache(0).remove(k, (Object)"0");
        Assert.assertNull((Object)this.advancedCache(0).getDataContainer().get(k));
        Assert.assertNull((Object)this.advancedCache(1).getDataContainer().get(k));
    }

    public void testPutIfAbsentFromMainOwner() {
        Object k = this.getKeyForCache(0);
        this.cache(0).put(k, (Object)"0");
        this.cache(0).putIfAbsent(k, (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(0).getDataContainer().get(k).getValue(), (Object)"0");
        Assert.assertEquals((Object)this.advancedCache(1).getDataContainer().get(k).getValue(), (Object)"0");
        this.cache(0).remove(k);
        this.cache(0).putIfAbsent(k, (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(0).getDataContainer().get(k).getValue(), (Object)"1");
        Assert.assertEquals((Object)this.advancedCache(1).getDataContainer().get(k).getValue(), (Object)"1");
    }
}

