/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="container.versioning.VersionedConditionalOperationsTest", groups={"functional"})
public class VersionedConditionalOperationsTest
extends MultipleCacheManagersTest {
    protected static final String KEY_1 = "key_1";
    protected static final String KEY_2 = "key_2";
    protected static final String VALUE_1 = "value_1";
    protected static final String VALUE_2 = "value_2";
    protected static final String VALUE_3 = "value_3";
    protected static final String VALUE_4 = "value_4";
    protected final int clusterSize;
    protected final CacheMode mode;
    protected final boolean syncCommit;

    public VersionedConditionalOperationsTest() {
        this(2, CacheMode.REPL_SYNC, true);
    }

    protected VersionedConditionalOperationsTest(int clusterSize, CacheMode mode, boolean syncCommit) {
        this.clusterSize = clusterSize;
        this.mode = mode;
        this.syncCommit = syncCommit;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = VersionedConditionalOperationsTest.getDefaultClusteredCacheConfig(this.mode, true);
        dcc.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createCluster(dcc, this.clusterSize);
        this.waitForClusterToForm();
    }

    public void testPutIfAbsent() {
        this.assertEmpty(KEY_1, KEY_2);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(1, KEY_1, VALUE_1);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(0, KEY_1, VALUE_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(1, KEY_1, VALUE_3);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(0, KEY_1, VALUE_3);
        this.cache(0).putIfAbsent((Object)KEY_2, (Object)VALUE_1);
        this.assertCacheValue(0, KEY_2, VALUE_1);
        this.assertNoTransactions();
    }

    public void testRemoveIfPresent() {
        this.assertEmpty(KEY_1);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(1, KEY_1, VALUE_2);
        this.cache(0).remove((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(0, KEY_1, VALUE_2);
        this.cache(0).remove((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(0, KEY_1, null);
        this.assertNoTransactions();
    }

    public void testReplaceWithOldVal() {
        this.assertEmpty(KEY_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(1, KEY_1, VALUE_1);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(0, KEY_1, VALUE_2);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_3, (Object)VALUE_4);
        this.assertCacheValue(0, KEY_1, VALUE_2);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_2, (Object)VALUE_4);
        this.assertCacheValue(0, KEY_1, VALUE_4);
        this.assertNoTransactions();
    }

    protected void assertEmpty(Object ... keys) {
        for (Cache cache : this.caches()) {
            for (Object key : keys) {
                Assert.assertNull((Object)cache.get(key));
            }
        }
    }

    protected void assertCacheValue(int originatorIndex, Object key, Object value) {
        for (int index = 0; index < this.caches().size(); ++index) {
            if (index == originatorIndex && this.mode.isSynchronous() || index != originatorIndex && this.syncCommit) {
                this.assertEquals(index, key, value);
                continue;
            }
            this.assertEventuallyEquals(index, key, value);
        }
    }

    private void assertEquals(int index, Object key, Object value) {
        assert (value != null ? value.equals(this.cache(index).get(key)) : value == this.cache(index).get(key));
    }
}

