/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.VersionedReplStateTransferTest", groups={"functional"})
public class VersionedReplStateTransferTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        this.builder.clustering().cacheMode(CacheMode.REPL_SYNC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).transaction().lockingMode(LockingMode.OPTIMISTIC).recovery().disable();
        this.createCluster(TestDataSCI.INSTANCE, this.builder, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        cache0.put((Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)cache0.get((Object)"hello"));
        AssertJUnit.assertEquals((Object)"world", (Object)cache1.get((Object)"hello"));
        this.tm(1).begin();
        AssertJUnit.assertEquals((Object)"world", (Object)cache1.get((Object)"hello"));
        Transaction t = this.tm(1).suspend();
        this.addClusterEnabledCacheManager(this.builder);
        Cache cache2 = this.cache(2);
        AssertJUnit.assertEquals((Object)"world", (Object)cache2.get((Object)"hello"));
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).stop();
        this.cacheManagers.remove(0);
        TestingUtil.waitForNoRebalance(this.caches());
        cache2.put((Object)"hello", (Object)"new world");
        this.tm(1).resume(t);
        cache1.put((Object)"hello", (Object)"world2");
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)this.tm(1)).commit());
        AssertJUnit.assertEquals((Object)"new world", (Object)cache1.get((Object)"hello"));
        AssertJUnit.assertEquals((Object)"new world", (Object)cache2.get((Object)"hello"));
    }
}

