/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="context.InvocationContextTest")
public class InvocationContextTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(InvocationContextTest.class);

    public InvocationContextTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC).useSynchronization(false).recovery().enabled(false);
        this.createClusteredCaches(1, "timestamps", builder);
    }

    public void testMishavingListenerResumesContext() {
        Cache cache = this.cache(0, "timestamps");
        cache.addListener((Object)new CacheListener());
        try {
            cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"k", (Object)"v");
            AssertJUnit.fail((String)"Should have failed with an exception");
        }
        catch (CacheException ce) {
            Throwable cause = ce.getCause();
            AssertJUnit.assertTrue((String)("Unexpected exception cause " + cause), (cause instanceof RollbackException || cause instanceof HeuristicRollbackException ? 1 : 0) != 0);
        }
    }

    public void testThreadInterruptedDuringLocking() throws Throwable {
        Cache cache = this.cache(0, "timestamps");
        cache.put((Object)"k", (Object)"v");
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        Transaction tx = tm.suspend();
        LinkedList throwables = new LinkedList();
        Thread th = new Thread(() -> {
            try {
                cache.put((Object)"k", (Object)"v3");
            }
            catch (Throwable th1) {
                throwables.add(th1);
            }
        });
        th.start();
        th.interrupt();
        th.join();
        tm.resume(tx);
        tm.rollback();
        AssertJUnit.assertEquals((int)1, (int)throwables.size());
        AssertJUnit.assertTrue((boolean)(throwables.get(0) instanceof CacheException));
        AssertJUnit.assertTrue((boolean)(((Throwable)throwables.get(0)).getCause() instanceof InterruptedException));
    }

    public void testThreadInterruptedAfterLocking() throws Throwable {
        Cache cache = this.cache(0, "timestamps");
        cache.put((Object)"k", (Object)"v");
        CountDownLatch willTimeoutLatch = new CountDownLatch(1);
        CountDownLatch lockAquiredSignal = new CountDownLatch(1);
        DelayingListener dl = new DelayingListener(lockAquiredSignal, willTimeoutLatch);
        cache.addListener((Object)dl);
        LinkedList throwables = new LinkedList();
        Future<Void> future = this.fork(() -> {
            try {
                cache.put((Object)"k", (Object)"v3");
            }
            catch (Throwable th) {
                throwables.add(th);
            }
        });
        lockAquiredSignal.await();
        dl.waitLatch.countDown();
        future.get(10L, TimeUnit.SECONDS);
        assert (throwables.size() == 1);
        assert (throwables.get(0) instanceof CacheException);
    }

    @Listener
    public static class CacheListener {
        @CacheEntryCreated
        @CacheEntryModified
        public void entryModified(CacheEntryEvent event) {
            if (!event.isPre()) {
                log.debugf("Entry modified: %s, let's throw an exception!!", (Object)event);
                throw new RuntimeException("Testing exception handling");
            }
        }
    }

    @Listener
    public static class DelayingListener {
        CountDownLatch lockAcquiredLatch;
        CountDownLatch waitLatch;

        public DelayingListener(CountDownLatch lockAcquiredLatch, CountDownLatch waitLatch) {
            this.lockAcquiredLatch = lockAcquiredLatch;
            this.waitLatch = waitLatch;
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent event) {
            if (!event.isPre()) {
                this.lockAcquiredLatch.countDown();
                try {
                    TestBlocking.await(this.waitLatch, 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException("Induced exception");
            }
        }
    }
}

