/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.JavaSerializationEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.dataconversion.FooBarTranscoder;
import org.infinispan.dataconversion.GzipEncoder;
import org.infinispan.dataconversion.ObjectXMLTranscoder;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="core.DataConversionTest")
public class DataConversionTest
extends AbstractInfinispanTest {
    @Test
    public void testReadUnencoded() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().storage(StorageType.OFF_HEAP);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){
            private final EncoderRegistry registry;
            {
                this.registry = TestingUtil.extractGlobalComponent((CacheContainer)this.cm, EncoderRegistry.class);
            }

            public Object asStored(Object object) {
                return this.registry.convert(object, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
            }

            @Override
            public void call() {
                this.cm.getClassAllowList().addClasses(new Class[]{Person.class});
                Cache cache = this.cm.getCache();
                Person value = new Person();
                cache.put((Object)"1", (Object)value);
                Assert.assertEquals((Object)cache.get((Object)"1"), (Object)value);
                AdvancedCache unencodedCache = cache.getAdvancedCache().withStorageMediaType();
                Assert.assertEquals((Object)unencodedCache.get(this.asStored("1")), (Object)this.asStored(value));
            }
        });
    }

    @Test
    public void testUTF8Encoders() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){
            String charset;
            {
                this.charset = "UTF-8";
            }

            private byte[] asUTF8Bytes(String value) throws UnsupportedEncodingException {
                return value.getBytes(this.charset);
            }

            @Override
            public void call() throws IOException {
                Cache cache = this.cm.getCache();
                String keyUnencoded = "1";
                String valueUnencoded = "value";
                cache.put((Object)this.asUTF8Bytes(keyUnencoded), (Object)this.asUTF8Bytes(valueUnencoded));
                AdvancedCache utf8Cache = cache.getAdvancedCache().withEncoding(UTF8Encoder.class);
                Assert.assertEquals((Object)utf8Cache.get((Object)keyUnencoded), (Object)valueUnencoded);
                String key2Unencoded = "2";
                String value2Unencoded = "anotherValue";
                utf8Cache.put((Object)key2Unencoded, (Object)value2Unencoded);
                Assert.assertEquals((byte[])((byte[])cache.get((Object)this.asUTF8Bytes(key2Unencoded))), (byte[])this.asUTF8Bytes(value2Unencoded));
            }
        });
    }

    @Test
    public void testExtractIndexable() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)new TestInterceptor(1));
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){

            @Override
            public void call() {
                ConfigurationBuilder offHeapConfig = new ConfigurationBuilder();
                offHeapConfig.memory().storage(StorageType.OFF_HEAP);
                offHeapConfig.customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)new TestInterceptor(1));
                ConfigurationBuilder compatConfig = new ConfigurationBuilder();
                compatConfig.customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)new TestInterceptor(1));
                this.cm.defineConfiguration("offheap", offHeapConfig.build());
                this.cm.defineConfiguration("compat", compatConfig.build());
                Cache cache = this.cm.getCache();
                Cache offheapCache = this.cm.getCache("offheap");
                Cache compatCache = this.cm.getCache("compat");
                cache.put((Object)1, (Object)1);
                offheapCache.put((Object)1, (Object)1);
                compatCache.put((Object)1, (Object)1);
                Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
                Assert.assertEquals((Object)1, (Object)offheapCache.get((Object)1));
                Assert.assertEquals((Object)1, (Object)compatCache.get((Object)1));
            }
        });
    }

    @Test
    public void testConversionWithListeners() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                this.cm.getClassAllowList().addClasses(new Class[]{Person.class});
                AdvancedCache storeMarshalled = cache.getAdvancedCache().withEncoding(JavaSerializationEncoder.class);
                SimpleListener simpleListener = new SimpleListener();
                storeMarshalled.addListener((Object)simpleListener);
                Person value = new Person();
                storeMarshalled.put((Object)"1", (Object)value);
                Assert.assertEquals((int)simpleListener.events.size(), (int)1);
                Assert.assertEquals((Object)((CacheEntryEvent)simpleListener.events.get(0)).getKey(), (Object)"1");
                Assert.assertEquals((Object)((CacheEntryEvent)simpleListener.events.get(0)).getValue(), (Object)value);
            }
        });
    }

    @Test
    public void testTranscoding() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.encoding().key().mediaType("application/x-java-object");
        cfg.encoding().value().mediaType("application/x-java-object");
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                EncoderRegistry encoderRegistry = TestingUtil.extractGlobalComponent((CacheContainer)this.cm, EncoderRegistry.class);
                encoderRegistry.registerTranscoder((Transcoder)new ObjectXMLTranscoder());
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("BTC", "Bitcoin");
                valueMap.put("ETH", "Ethereum");
                valueMap.put("LTC", "Litecoin");
                cache.put((Object)"CoinMap", valueMap);
                Assert.assertEquals(valueMap, (Object)cache.get((Object)"CoinMap"));
                AdvancedCache xmlCache = cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_XML);
                Assert.assertEquals((String)((String)xmlCache.get((Object)"CoinMap")), (String)"<root><BTC>Bitcoin</BTC><ETH>Ethereum</ETH><LTC>Litecoin</LTC></root>");
                Assert.assertEquals((Object)xmlCache.withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT).get((Object)"CoinMap"), valueMap);
                xmlCache.put((Object)"AltCoinMap", (Object)"<root><CAT>Catcoin</CAT><DOGE>Dogecoin</DOGE></root>");
                Map map = (Map)cache.get((Object)"AltCoinMap");
                Assert.assertEquals((String)((String)map.get("CAT")), (String)"Catcoin");
                Assert.assertEquals((String)((String)map.get("DOGE")), (String)"Dogecoin");
            }
        });
    }

    @Test
    public void testTranscodingWithCustomConfig() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE)){

            @Override
            public void call() {
                EncoderRegistry encoderRegistry = TestingUtil.extractGlobalComponent((CacheContainer)this.cm, EncoderRegistry.class);
                encoderRegistry.registerTranscoder((Transcoder)new FooBarTranscoder());
                ConfigurationBuilder cfg = new ConfigurationBuilder();
                cfg.encoding().key().mediaType("application/foo");
                cfg.encoding().value().mediaType("application/bar");
                this.cm.defineConfiguration("foobar", cfg.build());
                Cache cache = this.cm.getCache("foobar");
                cache.put((Object)"foo-key", (Object)"bar-value");
                Assert.assertEquals((String)((String)cache.get((Object)"foo-key")), (String)"bar-value");
                MediaType appFoo = MediaType.fromString((String)"application/foo");
                MediaType appBar = MediaType.fromString((String)"application/bar");
                AdvancedCache fooCache = cache.getAdvancedCache().withMediaType(appFoo, appFoo);
                Assert.assertEquals((String)((String)fooCache.get((Object)"foo-key")), (String)"foo-value");
                AdvancedCache barCache = cache.getAdvancedCache().withMediaType(appBar, appBar);
                Assert.assertEquals((String)((String)barCache.get((Object)"bar-key")), (String)"bar-value");
                AdvancedCache barFooCache = cache.getAdvancedCache().withMediaType(appBar, appFoo);
                Assert.assertEquals((String)((String)barFooCache.get((Object)"bar-key")), (String)"foo-value");
            }
        });
    }

    @Test
    public void testTextTranscoder() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.encoding().key().mediaType("text/plain; charset=ISO-8859-1");
        cfg.encoding().value().mediaType("text/plain; charset=UTF-8");
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg)){

            @Override
            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache().withStorageMediaType();
                byte[] key = "key1".getBytes(StandardCharsets.ISO_8859_1);
                byte[] value = new byte[]{97, 118, 105, -61, -93, 111};
                cache.put((Object)key, (Object)value);
                Assert.assertEquals((Object)cache.get((Object)key), (Object)value);
                AdvancedCache utf16ValueCache = cache.getAdvancedCache().withMediaType(MediaType.fromString((String)"text/plain; charset=ISO-8859-1"), MediaType.fromString((String)"text/plain; charset=UTF-16"));
                Assert.assertEquals((byte[])((byte[])utf16ValueCache.get((Object)key)), (byte[])new byte[]{-2, -1, 0, 97, 0, 118, 0, 105, 0, -29, 0, 111});
            }
        });
    }

    public void testWithCustomEncoder() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, new ConfigurationBuilder())){

            @Override
            public void call() {
                EncoderRegistry encoderRegistry = TestingUtil.extractGlobalComponent((CacheContainer)this.cm, EncoderRegistry.class);
                encoderRegistry.registerEncoder((Encoder)new GzipEncoder());
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                AdvancedCache compressingCache = cache.withEncoding(IdentityEncoder.class, GzipEncoder.class);
                compressingCache.put((Object)"297931749", (Object)"0412c789a37f5086f743255cfa693dd502b6a2ecb2ceee68380ff58ad15e7b56");
                Assert.assertEquals((String)((String)compressingCache.get((Object)"297931749")), (String)"0412c789a37f5086f743255cfa693dd502b6a2ecb2ceee68380ff58ad15e7b56");
                Object value = compressingCache.withEncoding(IdentityEncoder.class).get((Object)"297931749");
                assert (value instanceof byte[]);
            }
        });
    }

    @Test
    public void testSerialization() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, new ConfigurationBuilder())){
            GlobalMarshaller marshaller;
            {
                this.marshaller = TestingUtil.extractGlobalMarshaller(this.cm);
            }

            private void testWith(DataConversion dataConversion, ComponentRegistry registry) throws Exception {
                byte[] marshalled = this.marshaller.objectToByteBuffer((Object)dataConversion);
                Object back = this.marshaller.objectFromByteBuffer(marshalled);
                registry.wireDependencies(back);
                Assert.assertEquals((Object)back, (Object)dataConversion);
            }

            @Override
            public void call() throws Exception {
                ComponentRegistry registry = this.cm.getCache().getAdvancedCache().getComponentRegistry();
                this.testWith(DataConversion.DEFAULT_KEY, registry);
                this.testWith(DataConversion.DEFAULT_VALUE, registry);
                this.testWith(DataConversion.IDENTITY_KEY, registry);
                this.testWith(DataConversion.IDENTITY_VALUE, registry);
                ConfigurationBuilder builder = new ConfigurationBuilder();
                this.cm.defineConfiguration("compat", builder.build());
                AdvancedCache compat = this.cm.getCache("compat").getAdvancedCache();
                ComponentRegistry compatRegistry = compat.getComponentRegistry();
                this.testWith(compat.getKeyDataConversion(), compatRegistry);
                this.testWith(compat.getValueDataConversion(), compatRegistry);
                AdvancedCache wrapped = compat.withEncoding(IdentityEncoder.class).withWrapping(IdentityWrapper.class);
                ComponentRegistry wrappedRegistry = wrapped.getComponentRegistry();
                this.testWith(wrapped.getKeyDataConversion(), wrappedRegistry);
                this.testWith(wrapped.getValueDataConversion(), wrappedRegistry);
            }
        });
    }

    @Test
    public void testJavaSerialization() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.serialization().marshaller((Marshaller)new JavaSerializationMarshaller());
        try (DefaultCacheManager manager = new DefaultCacheManager(gcb.build());){
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.encoding().mediaType("application/x-java-serialized-object");
            Cache cache = manager.createCache("cache", builder.build());
            cache.put((Object)"key", (Object)"value");
            JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
            DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
            InternalCacheEntry cacheEntry = dataContainer.peek((Object)new WrappedByteArray(marshaller.objectToByteBuffer((Object)"key")));
            Assert.assertEquals((Object)new WrappedByteArray(marshaller.objectToByteBuffer((Object)"value")), (Object)cacheEntry.getValue());
        }
    }

    @Listener(observation=Listener.Observation.POST)
    private static class SimpleListener {
        private List<CacheEntryEvent> events = new ArrayList<CacheEntryEvent>();

        private SimpleListener() {
        }

        @CacheEntryCreated
        public void cacheEntryCreated(CacheEntryEvent ev) {
            this.events.add(ev);
        }
    }

    static class TestInterceptor
    extends BaseCustomAsyncInterceptor {
        private final int i;
        @Inject
        ComponentRef<AdvancedCache<?, ?>> cache;

        TestInterceptor(int i) {
            this.i = i;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            DataConversion valueDataConversion = ((AdvancedCache)this.cache.wired()).getValueDataConversion();
            Assert.assertNotNull((Object)valueDataConversion);
            Object value = command.getValue();
            Assert.assertEquals((Object)this.i, (Object)valueDataConversion.fromStorage(value));
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
    }
}

