/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Gzip {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(String str) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gis = new GZIPOutputStream(baos);){
                gis.write(str.getBytes(StandardCharsets.UTF_8));
                gis.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to compress", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String decompress(byte[] compressed) {
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(compressed));){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = gis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decompress", e);
        }
    }
}

