/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.dataconversion.Gzip;

public class GzipEncoder
implements Encoder {
    public Object toStorage(Object content) {
        assert (content instanceof String);
        return Gzip.compress(content.toString());
    }

    public Object fromStorage(Object content) {
        assert (content instanceof byte[]);
        return Gzip.decompress((byte[])content);
    }

    public MediaType getStorageFormat() {
        return MediaType.fromString((String)"application/gzip");
    }

    public boolean isStorageFormatFilterable() {
        return false;
    }

    public short id() {
        return 10000;
    }
}

