/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.core.EncoderRegistryImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="core.TranscoderRegistrationTest")
public class TranscoderRegistrationTest {
    public void testTranscoderLookup() {
        EncoderRegistryImpl encoderRegistry = new EncoderRegistryImpl();
        TestTranscoder t1 = new TestTranscoder(MediaType.APPLICATION_JSON, MediaType.APPLICATION_OBJECT);
        TestTranscoder t2 = new TestTranscoder(MediaType.APPLICATION_XML, MediaType.APPLICATION_OBJECT);
        DefaultTranscoder t3 = new DefaultTranscoder((Marshaller)new JavaSerializationMarshaller());
        encoderRegistry.registerTranscoder((Transcoder)t3);
        encoderRegistry.registerTranscoder((Transcoder)t2);
        encoderRegistry.registerTranscoder((Transcoder)t1);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT), (Object)t3);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN), (Object)t3);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT), (Object)t3);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OCTET_STREAM), (Object)t3);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT), (Object)t3);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM), (Object)t3);
        this.assertNotFound((EncoderRegistry)encoderRegistry, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        this.assertNotFound((EncoderRegistry)encoderRegistry, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, MediaType.APPLICATION_OBJECT), (Object)t1);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON), (Object)t1);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_XML, MediaType.APPLICATION_OBJECT), (Object)t2);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_XML), (Object)t2);
        Assert.assertEquals((Object)encoderRegistry.getTranscoder(MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.APPLICATION_WWW_FORM_URLENCODED), (Object)t3);
    }

    private void assertNotFound(EncoderRegistry registry, MediaType one, MediaType other) {
        try {
            registry.getTranscoder(one, other);
            Assert.fail((String)"Should not have found transcoder");
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
    }

    private static final class TestTranscoder
    implements Transcoder {
        Set<MediaType> supportedSet = new HashSet<MediaType>();

        TestTranscoder(MediaType ... supported) {
            this.supportedSet.addAll(Arrays.asList(supported));
        }

        public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
            return content;
        }

        public Set<MediaType> getSupportedMediaTypes() {
            return this.supportedSet;
        }

        public String toString() {
            return "TestTranscoder{supportedSet=" + this.supportedSet + '}';
        }
    }
}

