/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.DistCacheWriterInterceptor;
import org.infinispan.interceptors.impl.ScatteredCacheWriterInterceptor;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;

public abstract class BaseDistStoreTest<K, V, C extends BaseDistStoreTest>
extends BaseDistFunctionalTest<K, V> {
    protected boolean shared;
    protected boolean preload;
    protected boolean segmented;

    protected C shared(boolean shared) {
        this.shared = shared;
        return (C)this;
    }

    protected C preload(boolean preload) {
        this.preload = preload;
        return (C)this;
    }

    protected C segmented(boolean segmented) {
        this.segmented = segmented;
        return (C)this;
    }

    @Override
    protected String[] parameterNames() {
        return BaseDistStoreTest.concat(super.parameterNames(), "shared", "preload", "segmented");
    }

    @Override
    protected Object[] parameterValues() {
        return BaseDistStoreTest.concat(super.parameterValues(), this.shared, this.preload, this.segmented);
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder cfg = super.buildConfiguration();
        StoreConfigurationBuilder storeConfigurationBuilder = this.addStore(cfg.persistence(), this.shared);
        ((StoreConfigurationBuilder)((StoreConfigurationBuilder)storeConfigurationBuilder.shared(this.shared)).preload(this.preload)).segmented(this.segmented);
        return cfg;
    }

    protected StoreConfigurationBuilder addStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder, boolean shared) {
        if (shared) {
            return persistenceConfigurationBuilder.addStore((StoreConfigurationBuilder)new DummyInMemoryStoreConfigurationBuilder(persistenceConfigurationBuilder).storeName(this.getClass().getSimpleName()));
        }
        return persistenceConfigurationBuilder.addStore((StoreConfigurationBuilder)new DummyInMemoryStoreConfigurationBuilder(persistenceConfigurationBuilder));
    }

    protected int getCacheStoreStats(Cache<?, ?> cache, String cacheStoreMethod) {
        DummyInMemoryStore dummyInMemoryStore = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        return dummyInMemoryStore.stats().get(cacheStoreMethod);
    }

    protected void assertNumberOfInvocations(DummyInMemoryStore dims, String method, int expected) {
        AssertJUnit.assertEquals((int)expected, (int)dims.stats().get(method));
    }

    protected void clearStats(Cache<?, ?> cache) {
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        store.clearStats();
        CacheWriterInterceptor cacheWriterInterceptor = this.getCacheWriterInterceptor(cache);
        if (cacheWriterInterceptor != null) {
            cacheWriterInterceptor.resetStatistics();
        }
    }

    protected CacheWriterInterceptor getCacheWriterInterceptor(Cache<?, ?> cache) {
        CacheWriterInterceptor cacheWriterInterceptor = (CacheWriterInterceptor)TestingUtil.extractComponent(cache, DistCacheWriterInterceptor.class);
        if (cacheWriterInterceptor == null) {
            cacheWriterInterceptor = (CacheWriterInterceptor)TestingUtil.extractComponent(cache, ScatteredCacheWriterInterceptor.class);
        }
        return cacheWriterInterceptor;
    }
}

