/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BlockingInterceptor<T extends VisitableCommand>
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(BlockingInterceptor.class);
    private final CyclicBarrier barrier;
    private final boolean blockAfter;
    private final boolean originLocalOnly;
    private final AtomicBoolean suspended = new AtomicBoolean();
    private final Predicate<VisitableCommand> acceptCommand;

    public BlockingInterceptor(CyclicBarrier barrier, Class<T> commandClass, boolean blockAfter, boolean originLocalOnly) {
        this(barrier, commandClass, blockAfter, originLocalOnly, t -> t != null && commandClass.equals(t.getClass()));
    }

    public BlockingInterceptor(CyclicBarrier barrier, Class<T> commandClass, boolean blockAfter, boolean originLocalOnly, Predicate<T> acceptCommand) {
        this(barrier, blockAfter, originLocalOnly, t -> t != null && commandClass.equals(t.getClass()) && acceptCommand.test((VisitableCommand)commandClass.cast(t)));
    }

    public BlockingInterceptor(CyclicBarrier barrier, boolean blockAfter, boolean originLocalOnly, Predicate<VisitableCommand> acceptCommand) {
        this.barrier = barrier;
        this.blockAfter = blockAfter;
        this.originLocalOnly = originLocalOnly;
        this.acceptCommand = acceptCommand;
    }

    public void suspend(boolean s) {
        this.suspended.set(s);
    }

    public void proceed() throws Exception {
        this.barrier.await(30L, TimeUnit.SECONDS);
    }

    private void blockIfNeeded(InvocationContext ctx, VisitableCommand command) throws Exception {
        if (this.suspended.get()) {
            log.tracef("Suspended, not blocking command %s", (Object)command);
            return;
        }
        if ((!this.originLocalOnly || ctx.isOriginLocal()) && this.acceptCommand.test(command)) {
            log.tracef("Command blocking %s completion of %s", (Object)(this.blockAfter ? "after" : "before"), (Object)command);
            this.barrier.await(30L, TimeUnit.SECONDS);
            this.barrier.await(30L, TimeUnit.SECONDS);
            log.tracef("Command completed blocking completion of %s", (Object)command);
        } else {
            log.tracef("Not blocking command %s", (Object)command);
        }
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (!this.blockAfter) {
            this.blockIfNeeded(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (this.blockAfter) {
                this.blockIfNeeded(rCtx, rCommand);
            }
        });
    }
}

