/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletableFutures;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="distribution.ConcurrentStartWithReplTest", groups={"functional"})
public class ConcurrentStartWithReplTest
extends AbstractInfinispanTest {
    private ConfigurationBuilder replCfg;
    private ConfigurationBuilder distCfg;

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.replCfg = MultipleCacheManagersTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.replCfg.clustering().stateTransfer().fetchInMemoryState(true);
        this.distCfg = MultipleCacheManagersTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.distCfg.clustering().stateTransfer().fetchInMemoryState(true);
    }

    @Test(timeOut=60000L)
    public void testSequence1() throws ExecutionException, InterruptedException {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        this.doTest(true, false);
    }

    @Test(timeOut=60000L)
    public void testSequence2() throws ExecutionException, InterruptedException {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        this.doTest(false, false);
    }

    @Test(timeOut=60000L)
    public void testSequence3() throws ExecutionException, InterruptedException {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        this.doTest(true, true);
    }

    @Test(timeOut=60000L)
    public void testSequence4() throws ExecutionException, InterruptedException {
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        this.doTest(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(boolean inOrder, boolean nonBlockingStartupForDist) throws ExecutionException, InterruptedException {
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder());
        try {
            cm1.defineConfiguration("r", this.replCfg.build());
            cm1.defineConfiguration("d", this.distCfg.build());
            cm2.defineConfiguration("r", this.replCfg.build());
            cm2.defineConfiguration("d", this.distCfg.build());
            Cache<String, String> c1r = this.startCache((CacheContainer)cm1, "r", false).get();
            c1r.put((Object)"key", (Object)"value");
            Cache<String, String> c2r = this.startCache((CacheContainer)cm2, "r", false).get();
            TestingUtil.blockUntilViewsReceived(10000L, c1r, c2r);
            TestingUtil.waitForNoRebalance(c1r, c2r);
            assert ("value".equals(c2r.get((Object)"key")));
            Future<Cache<String, String>> c1df = this.startCache((CacheContainer)(inOrder ? cm1 : cm2), "d", nonBlockingStartupForDist);
            Future<Cache<String, String>> c2df = this.startCache((CacheContainer)(inOrder ? cm2 : cm1), "d", nonBlockingStartupForDist);
            Cache<String, String> c1d = c1df.get();
            Cache<String, String> c2d = c2df.get();
            c1d.put((Object)"key", (Object)"value");
            assert ("value".equals(c2d.get((Object)"key")));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    private Future<Cache<String, String>> startCache(CacheContainer cm, String cacheName, boolean nonBlockingStartup) {
        Callable<Cache> cacheCreator = () -> cm.getCache(cacheName);
        if (nonBlockingStartup) {
            return this.fork(cacheCreator);
        }
        try {
            Cache cache = cacheCreator.call();
            return CompletableFuture.completedFuture(cache);
        }
        catch (Exception e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }
}

