/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.AbstractCacheTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSkipRemoteLookupBatchingTest")
public class DistSkipRemoteLookupBatchingTest
extends BaseDistFunctionalTest<Object, String> {
    public DistSkipRemoteLookupBatchingTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.batchingEnabled = true;
        this.transactional = true;
    }

    public void testSkipLookupOnGetWhileBatching() {
        MagicKey k1 = new MagicKey(this.c1, this.c2);
        this.c1.put((Object)k1, (Object)"batchingMagicValue-h1");
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsNotInL1(this.c3, k1);
        this.assertIsNotInL1(this.c4, k1);
        this.c4.startBatch();
        assert (this.c4.getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)k1) == null);
        this.c4.endBatch(true);
        this.assertOwnershipAndNonOwnership(k1, false);
    }
}

