/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistStorePreloadTest")
public class DistStorePreloadTest<D extends DistStorePreloadTest<?>>
extends BaseDistStoreTest<String, String, D> {
    public static final int NUM_KEYS = 10;

    public DistStorePreloadTest() {
        this.INIT_CLUSTER_SIZE = 1;
        this.testRetVals = true;
        this.shared = true;
        this.preload = true;
    }

    @Override
    public Object[] factory() {
        return new Object[]{((DistStorePreloadTest)new DistStorePreloadTest<D>().segmented(true)).transactional(false), ((DistStorePreloadTest)new DistStorePreloadTest<D>().segmented(true)).transactional(true), ((DistStorePreloadTest)new DistStorePreloadTest<D>().segmented(false)).transactional(false), ((DistStorePreloadTest)new DistStorePreloadTest<D>().segmented(false)).transactional(true)};
    }

    @AfterMethod
    public void clearStats() {
        for (Cache c : this.caches) {
            log.trace((Object)("Clearing stats for cache store on cache " + c));
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            store.clear();
        }
        if (this.managers().length > 1) {
            this.killMember(1, this.cacheName);
        }
    }

    public void testPreloadOnStart() throws PersistenceException {
        for (int i = 0; i < 10; ++i) {
            this.c1.put((Object)("k" + i), (Object)("v" + i));
        }
        DataContainer dc1 = this.c1.getAdvancedCache().getDataContainer();
        assert (dc1.size() == 10);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.c1);
        AssertJUnit.assertEquals((long)10L, (long)store.size());
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, null, new TransportFlags().withFD(false));
        EmbeddedCacheManager cm2 = (EmbeddedCacheManager)this.cacheManagers.get(1);
        cm2.defineConfiguration(this.cacheName, this.buildConfiguration().build());
        this.c2 = this.cache(1, this.cacheName);
        this.caches.add(this.c2);
        this.waitForClusterToForm(this.cacheName);
        DataContainer dc2 = this.c2.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((String)"Expected all the cache store entries to be preloaded on the second cache", (int)10, (int)dc2.size());
        for (int i = 0; i < 10; ++i) {
            this.assertOwnershipAndNonOwnership("k" + i, true);
        }
    }

    public void testPreloadExpirationMemoryPresent() {
        this.testPreloadExpiration(true);
    }

    public void testPreloadExpirationNoMemoryPresent() {
        this.testPreloadExpiration(false);
    }

    private void testPreloadExpiration(boolean hasMemoryContents) {
        ControlledTimeService timeService = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.c1.getCacheManager(), TimeService.class, timeService, true);
        long createdTime = timeService.wallClockTime();
        String key = "key";
        String value = "value";
        this.c1.put((Object)key, (Object)value, 10L, TimeUnit.MINUTES);
        DataContainer dc1 = this.c1.getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = dc1.get((Object)key);
        AssertJUnit.assertNotNull((Object)entry);
        AssertJUnit.assertEquals((long)createdTime, (long)entry.getCreated());
        if (!hasMemoryContents) {
            dc1.clear();
        }
        timeService.advance(1000L);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.c1);
        AssertJUnit.assertEquals((long)1L, (long)store.size());
        this.addClusterEnabledCacheManager();
        EmbeddedCacheManager cm2 = (EmbeddedCacheManager)this.cacheManagers.get(1);
        TestingUtil.replaceComponent((CacheContainer)cm2, TimeService.class, timeService, true);
        cm2.defineConfiguration(this.cacheName, this.buildConfiguration().build());
        this.c2 = this.cache(1, this.cacheName);
        this.caches.add(this.c2);
        this.waitForClusterToForm(this.cacheName);
        DataContainer dc2 = this.c2.getAdvancedCache().getDataContainer();
        entry = dc2.get((Object)key);
        AssertJUnit.assertNotNull((Object)entry);
        AssertJUnit.assertEquals((long)createdTime, (long)entry.getCreated());
    }
}

