/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.distribution.BaseDistSyncL1Test;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="distribution.DistSyncL1FuncTest")
public class DistSyncL1FuncTest
extends BaseDistSyncL1Test {
    public DistSyncL1FuncTest() {
        this.testRetVals = true;
    }

    @Override
    protected Class<? extends AsyncInterceptor> getDistributionInterceptorClass() {
        return this.isTriangle() ? TriangleDistributionInterceptor.class : NonTxDistributionInterceptor.class;
    }

    @Override
    protected Class<? extends AsyncInterceptor> getL1InterceptorClass() {
        return L1NonTxInterceptor.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertL1PutWithConcurrentUpdate(Cache<Object, String> nonOwnerCache, Cache<Object, String> ownerCache, boolean replace, Object key, String originalValue, String nonOwnerValue, String updateValue) throws Throwable {
        CyclicBarrier barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor = this.addBlockingInterceptorBeforeTx(nonOwnerCache, barrier, replace ? ReplaceCommand.class : PutKeyValueCommand.class);
        try {
            Future<String> future = this.fork(() -> {
                if (replace) {
                    if (nonOwnerCache.replace(key, (Object)originalValue, (Object)nonOwnerValue)) {
                        return originalValue;
                    }
                    return (String)nonOwnerCache.get(key);
                }
                return (String)nonOwnerCache.put(key, (Object)nonOwnerValue);
            });
            barrier.await(5L, TimeUnit.SECONDS);
            blockingInterceptor.suspend(true);
            AssertJUnit.assertEquals((String)nonOwnerValue, (String)((String)ownerCache.put(key, (Object)updateValue)));
            barrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)originalValue, (String)future.get(5L, TimeUnit.SECONDS));
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            this.assertL1StateOnLocalWrite(nonOwnerCache, ownerCache, key, updateValue);
            AssertJUnit.assertEquals((String)updateValue, (String)((String)nonOwnerCache.get(key)));
            this.assertIsInL1(nonOwnerCache, key);
        }
        finally {
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    public void testNoEntryInL1PutWithConcurrentInvalidation() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, ownerCache, false, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testEntryInL1PutWithConcurrentInvalidation() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        nonOwnerCache.get((Object)"key-to-the-cache");
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, ownerCache, false, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testNoEntryInL1PutWithConcurrentPut() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, false, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testEntryInL1PutWithConcurrentPut() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        nonOwnerCache.get((Object)"key-to-the-cache");
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, false, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testNoEntryInL1ReplaceWithConcurrentInvalidation() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, ownerCache, true, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testEntryInL1ReplaceWithConcurrentInvalidation() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        nonOwnerCache.get((Object)"key-to-the-cache");
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, ownerCache, true, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testNoEntryInL1ReplaceWithConcurrentPut() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, true, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testEntryInL1ReplaceWithConcurrentPut() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        nonOwnerCache.get((Object)"key-to-the-cache");
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, true, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    public void testNoEntryInL1GetWithConcurrentReplace() throws Throwable {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        nonOwnerCache.get((Object)"key-to-the-cache");
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        this.assertL1PutWithConcurrentUpdate(nonOwnerCache, nonOwnerCache, true, "key-to-the-cache", "first-put", "intermediate-put", "second-put");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoEntryInL1PutReplacedNullValueConcurrently() throws InterruptedException, ExecutionException, TimeoutException {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ControlledRpcManager crm = ControlledRpcManager.replaceRpcManager(nonOwnerCache);
        crm.excludeCommands(ClusteredGetCommand.class);
        try {
            Future<String> future = this.fork(() -> (String)nonOwnerCache.putIfAbsent((Object)"key-to-the-cache", (Object)"first-put"));
            ControlledRpcManager.BlockedResponseMap blockedPutResponses = crm.expectCommand(PutKeyValueCommand.class).send().expectAllResponses();
            AssertJUnit.assertEquals((String)"first-put", (String)((String)ownerCache.remove((Object)"key-to-the-cache")));
            blockedPutResponses.receive();
            AssertJUnit.assertNull((Object)future.get(5L, TimeUnit.SECONDS));
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
            AssertJUnit.assertNull((Object)nonOwnerCache.get((Object)"key-to-the-cache"));
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        }
        finally {
            crm.revertRpcManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonOwnerRetrievesValueFromBackupOwnerWhileWrite() throws Exception {
        Cache<K, V>[] owners = this.getOwners("key-to-the-cache", 2);
        Cache ownerCache = owners[0];
        Cache backupOwnerCache = owners[1];
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        CyclicBarrier ownerGetBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(ownerCache, ownerGetBarrier, GetCacheEntryCommand.class, L1NonTxInterceptor.class, false);
        CyclicBarrier backupOwnerWriteBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(backupOwnerCache, backupOwnerWriteBarrier, PutKeyValueCommand.class, L1NonTxInterceptor.class, true);
        try {
            Future<String> future = this.fork(() -> (String)ownerCache.put((Object)"key-to-the-cache", (Object)"second-put"));
            backupOwnerWriteBarrier.await(5L, TimeUnit.SECONDS);
            this.eventually(() -> !this.isInL1(nonOwnerCache, "key-to-the-cache"), 5000L, TimeUnit.MILLISECONDS);
            AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
            this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
            backupOwnerWriteBarrier.await(5L, TimeUnit.SECONDS);
            future.get(5L, TimeUnit.SECONDS);
            this.eventually(() -> !this.isInL1(nonOwnerCache, "key-to-the-cache"), 5000L, TimeUnit.MILLISECONDS);
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
            ownerGetBarrier.await(5L, TimeUnit.SECONDS);
            ownerGetBarrier.await(5L, TimeUnit.SECONDS);
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        }
        finally {
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(ownerCache);
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(backupOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonOwnerRemovesValueFromL1ProperlyOnWrite() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        Cache<K, V>[] owners = this.getOwners("key-to-the-cache", 2);
        Cache ownerCache = owners[0];
        Cache backupOwnerCache = owners[1];
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        CyclicBarrier ownerPutBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(ownerCache, ownerPutBarrier, PutKeyValueCommand.class, L1NonTxInterceptor.class, true);
        CyclicBarrier backupGetBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(backupOwnerCache, backupGetBarrier, GetCacheEntryCommand.class, L1NonTxInterceptor.class, false);
        try {
            Future<String> future = this.fork(() -> (String)nonOwnerCache.put((Object)"key-to-the-cache", (Object)"second-put"));
            ownerPutBarrier.await(10L, TimeUnit.SECONDS);
            CommandAckCollector collector = TestingUtil.extractComponent(nonOwnerCache, CommandAckCollector.class);
            List pendingIds = collector.getPendingCommands();
            AssertJUnit.assertEquals((int)1, (int)pendingIds.size());
            this.eventually(() -> !collector.hasPendingBackupAcks(((Long)pendingIds.get(0)).longValue()));
            AssertJUnit.assertEquals((String)"first-put", (String)((String)ownerCache.getAdvancedCache().getDataContainer().peek((Object)"key-to-the-cache").getValue()));
            AssertJUnit.assertEquals((String)"second-put", (String)((String)backupOwnerCache.getAdvancedCache().getDataContainer().peek((Object)"key-to-the-cache").getValue()));
            AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
            this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
            try {
                backupGetBarrier.await(5L, TimeUnit.SECONDS);
                backupGetBarrier.await(5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ownerPutBarrier.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"first-put", (String)future.get(10L, TimeUnit.SECONDS));
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
            AssertJUnit.assertEquals((String)"second-put", (String)((String)ownerCache.getAdvancedCache().getDataContainer().peek((Object)"key-to-the-cache").getValue()));
        }
        finally {
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(ownerCache);
            DistSyncL1FuncTest.removeAllBlockingInterceptorsFromCache(backupOwnerCache);
        }
    }
}

