/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncL1PassivationFuncTest")
public class DistSyncL1PassivationFuncTest
extends BaseDistFunctionalTest {
    protected int MAX_ENTRIES = 4;
    protected DummyInMemoryStore ownerCacheStore;
    protected DummyInMemoryStore nonOwnerCacheStore;

    public DistSyncL1PassivationFuncTest() {
        this.testRetVals = true;
        this.numOwners = 1;
        this.INIT_CLUSTER_SIZE = 2;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.ownerCacheStore = (DummyInMemoryStore)TestingUtil.extractComponent(this.cache(0, this.cacheName), PersistenceManager.class).getStores(DummyInMemoryStore.class).iterator().next();
        this.nonOwnerCacheStore = (DummyInMemoryStore)TestingUtil.extractComponent(this.cache(1, this.cacheName), PersistenceManager.class).getStores(DummyInMemoryStore.class).iterator().next();
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = super.buildConfiguration();
        builder.memory().size((long)this.MAX_ENTRIES).persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return builder;
    }

    @Test
    public void testPassivatedL1Entries() {
        int minPassivated = 2;
        int insertCount = this.MAX_ENTRIES + 2;
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(insertCount);
        Cache ownerCache = this.cache(0, this.cacheName);
        Cache nonOwnerCache = this.cache(1, this.cacheName);
        for (int i = 0; i < insertCount; ++i) {
            MagicKey key = new MagicKey(ownerCache);
            while (ownerCache.putIfAbsent((Object)key, (Object)key) != null) {
                key = new MagicKey(ownerCache);
            }
            keys.add(key);
        }
        this.eventually(() -> this.ownerCacheStore.size() >= 2L);
        AssertJUnit.assertTrue((this.MAX_ENTRIES >= ownerCache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)nonOwnerCache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).size());
        AssertJUnit.assertEquals((long)0L, (long)this.nonOwnerCacheStore.size());
        for (MagicKey key : keys) {
            nonOwnerCache.get((Object)key);
        }
        AssertJUnit.assertEquals((String)"Some L1 values were passivated", (long)0L, (long)this.nonOwnerCacheStore.size());
    }
}

