/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncL1PessimisticFuncTest")
public class DistSyncL1PessimisticFuncTest
extends BaseDistFunctionalTest {
    public DistSyncL1PessimisticFuncTest() {
        this.transactional = true;
        this.testRetVals = true;
        this.lockingMode = LockingMode.PESSIMISTIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteLockBlockingForceWriteL1Update() throws Exception {
        String key = "some-key";
        String value = "some-value";
        String otherValue = "some-new-value";
        final Cache nonOwner = this.getFirstNonOwner("some-key");
        Cache owner = this.getFirstOwner("some-key");
        owner.put((Object)"some-key", (Object)value);
        nonOwner.get((Object)"some-key");
        this.assertIsInL1(nonOwner, "some-key");
        try {
            TransactionManager ownerManger = TestingUtil.getTransactionManager(owner);
            ownerManger.begin();
            owner.put((Object)"some-key", (Object)"some-new-value");
            Future<String> futureGet = this.fork(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    TransactionManager mgr = TestingUtil.getTransactionManager(nonOwner);
                    mgr.begin();
                    try {
                        String string = (String)nonOwner.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)"some-key");
                        return string;
                    }
                    finally {
                        mgr.commit();
                    }
                }
            });
            try {
                futureGet.get(1L, TimeUnit.SECONDS);
                AssertJUnit.fail((String)"Get command should have blocked waiting");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ownerManger.commit();
            AssertJUnit.assertEquals((String)"some-new-value", (String)futureGet.get(1L, TimeUnit.SECONDS));
            this.assertIsInL1(nonOwner, "some-key");
        }
        finally {
            nonOwner.getAdvancedCache().getAsyncInterceptorChain().removeInterceptor(BlockingInterceptor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceWriteLockWithL1Invalidation() throws Exception {
        String key = "some-key";
        String value = "some-value";
        String otherValue = "some-new-value";
        final Cache nonOwner = this.getFirstNonOwner("some-key");
        final Cache owner = this.getFirstOwner("some-key");
        owner.put((Object)"some-key", (Object)value);
        nonOwner.get((Object)"some-key");
        this.assertIsInL1(nonOwner, "some-key");
        try {
            TransactionManager ownerManger = TestingUtil.getTransactionManager(owner);
            ownerManger.begin();
            AssertJUnit.assertEquals((String)value, (String)((String)nonOwner.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)"some-key")));
            Future<String> futurePut = this.fork(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    TransactionManager mgr = TestingUtil.getTransactionManager(nonOwner);
                    mgr.begin();
                    try {
                        String string = (String)owner.put((Object)"some-key", (Object)"some-new-value");
                        return string;
                    }
                    finally {
                        mgr.commit();
                    }
                }
            });
            try {
                futurePut.get(1L, TimeUnit.SECONDS);
                AssertJUnit.fail((String)"Get command should have blocked waiting");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ownerManger.commit();
            AssertJUnit.assertEquals((String)value, (String)futurePut.get(1L, TimeUnit.SECONDS));
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return !DistSyncL1PessimisticFuncTest.this.isInL1(nonOwner, "some-key");
                }
            });
            this.assertIsNotInL1(nonOwner, "some-key");
        }
        finally {
            nonOwner.getAdvancedCache().getAsyncInterceptorChain().removeInterceptor(BlockingInterceptor.class);
        }
    }
}

