/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncTxFuncTest")
public class DistSyncTxFuncTest
extends BaseDistFunctionalTest<Object, String> {
    public DistSyncTxFuncTest() {
        this.transactional = true;
        this.testRetVals = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testTransactionsSpanningKeysCommit() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        this.assertNotLocked((Cache<?, ?>)this.c3, (Object)k1);
        tm4.begin();
        this.c4.put((Object)k1, (Object)"new_value1");
        this.c4.put((Object)k2, (Object)"new_value2");
        tm4.commit();
        this.assertNotLocked((Cache<?, ?>)this.c3, (Object)k1);
        this.assertNotLocked((Cache<?, ?>)this.c3, (Object)k2);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.assertNotLocked(this.c4, k1, k2);
        this.assertNotLocked((Cache<?, ?>)this.c3, (Object)k1);
        this.assertNotLocked((Cache<?, ?>)this.c3, (Object)k2);
        this.assertNotLocked(this.c1, k1, k2);
        this.assertNotLocked(this.c2, k1, k2);
        this.checkOwnership(k1, k2, "new_value1", "new_value2");
    }

    public void testTransactionsSpanningKeysRollback() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.c4.put((Object)k1, (Object)"new_value1");
        this.c4.put((Object)k2, (Object)"new_value2");
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertTransactionOriginatorDataAfterRollback((Cache<Object, String>)this.c4, k1, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testPutFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.assertRetVal("value1", (String)this.c4.put((Object)k1, (Object)"new_value"));
        this.assertRetVal("value2", (String)this.c4.put((Object)k2, (Object)"new_value"));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertTransactionOriginatorDataAfterRollback((Cache<Object, String>)this.c4, k1, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testPutIfAbsentFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        LockManager lockManager4 = TestingUtil.extractComponent(this.c4, LockManager.class);
        tm4.begin();
        this.assertRetVal("value1", (String)this.c4.putIfAbsent((Object)k1, (Object)"new_value"));
        this.assertRetVal("value2", (String)this.c4.putIfAbsent((Object)k2, (Object)"new_value"));
        AssertJUnit.assertEquals((String)"value1", (String)((String)this.c4.get((Object)k1)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)this.c4.get((Object)k2)));
        tm4.rollback();
        AssertJUnit.assertFalse((boolean)lockManager4.isLocked((Object)k1));
        AssertJUnit.assertFalse((boolean)lockManager4.isLocked((Object)k2));
        AssertJUnit.assertEquals((String)"value1", (String)((String)this.c2.get((Object)k1)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)this.c2.get((Object)k2)));
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertTransactionOriginatorDataAfterRollback((Cache<Object, String>)this.c4, k1, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testRemoveFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        this.assertNotLocked(this.c1, k1, k2);
        this.assertNotLocked(this.c2, k1, k2);
        this.assertNotLocked(this.c3, k1, k2);
        this.assertNotLocked(this.c4, k1, k2);
        log.info((Object)"***** Here it starts!");
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.assertRetVal("value1", (String)this.c4.remove((Object)k1));
        this.assertRetVal("value2", (String)this.c4.remove((Object)k2));
        AssertJUnit.assertFalse((boolean)this.c4.containsKey((Object)k1));
        AssertJUnit.assertFalse((boolean)this.c4.containsKey((Object)k2));
        tm4.rollback();
        log.info((Object)"----- Here it ends!");
        this.assertNotLocked(this.c1, k1, k2);
        this.assertNotLocked(this.c2, k1, k2);
        this.assertNotLocked(this.c3, k1, k2);
        this.assertNotLocked((Cache<?, ?>)this.c4, (Object)k1);
        this.assertNotLocked((Cache<?, ?>)this.c4, (Object)k2);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertNotLocked(this.c1, k1, k2);
        this.assertNotLocked(this.c2, k1, k2);
        this.assertNotLocked(this.c3, k1, k2);
        this.assertNotLocked(this.c4, k1, k2);
        this.assertTransactionOriginatorDataAfterRollback((Cache<Object, String>)this.c4, k1, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.assertNotLocked(this.c1, k1, k2);
        this.assertNotLocked(this.c2, k1, k2);
        this.assertNotLocked(this.c3, k1, k2);
        this.assertNotLocked(this.c4, k1, k2);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testConditionalRemoveFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.assertRetVal(false, this.c4.remove((Object)k1, (Object)"valueX"));
        this.assertRetVal(false, this.c4.remove((Object)k1, (Object)"valueX"));
        AssertJUnit.assertTrue((boolean)this.c4.containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.c4.containsKey((Object)k2));
        this.assertRetVal(true, this.c4.remove((Object)k1, (Object)"value1"));
        this.assertRetVal(true, this.c4.remove((Object)k2, (Object)"value2"));
        AssertJUnit.assertFalse((boolean)this.c4.containsKey((Object)k1));
        AssertJUnit.assertFalse((boolean)this.c4.containsKey((Object)k2));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testReplaceFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.assertRetVal("value1", (String)this.c4.replace((Object)k1, (Object)"new_value"));
        this.assertRetVal("value2", (String)this.c4.replace((Object)k2, (Object)"new_value"));
        AssertJUnit.assertEquals((String)"new_value", (String)((String)this.c4.get((Object)k1)));
        AssertJUnit.assertEquals((String)"new_value", (String)((String)this.c4.get((Object)k2)));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertTransactionOriginatorDataAfterRollback((Cache<Object, String>)this.c4, k1, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testConditionalReplaceFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1, this.c2);
        MagicKey k2 = new MagicKey("k2", this.c2, this.c3);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.assertRetVal(false, this.c4.replace((Object)k1, (Object)"valueX", (Object)"new_value"));
        this.assertRetVal(false, this.c4.replace((Object)k2, (Object)"valueX", (Object)"new_value"));
        AssertJUnit.assertEquals((String)"value1", (String)((String)this.c4.get((Object)k1)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)this.c4.get((Object)k2)));
        this.assertRetVal(true, this.c4.replace((Object)k1, (Object)"value1", (Object)"new_value"));
        this.assertRetVal(true, this.c4.replace((Object)k2, (Object)"value2", (Object)"new_value"));
        AssertJUnit.assertEquals((String)"new_value", (String)((String)this.c4.get((Object)k1)));
        AssertJUnit.assertEquals((String)"new_value", (String)((String)this.c4.get((Object)k2)));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = super.buildConfiguration();
        ControlledConsistentHashFactory.Default chf = new ControlledConsistentHashFactory.Default(new int[][]{{0, 1}, {1, 2}});
        builder.clustering().hash().numOwners(2).numSegments(2).consistentHashFactory((ConsistentHashFactory)chf);
        return builder;
    }

    private void checkOwnership(MagicKey k1, MagicKey k2, String v1, String v2) {
        this.assertOnAllCachesAndOwnership(k1, v1);
        this.assertOnAllCachesAndOwnership(k2, v2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsInL1(this.c1, k2);
        this.assertIsInL1(this.c3, k1);
    }

    private void assertNotLocked(Cache c, Object ... keys) {
        LockManager lm = TestingUtil.extractComponent(c, LockManager.class);
        for (Object key : keys) {
            DistSyncTxFuncTest.eventually(() -> String.format("Expected unlocked key '%s' (lock-owner='%s')", key, lm.getOwner(key)), () -> !lm.isLocked(key));
        }
    }

    private void init(MagicKey k1, MagicKey k2) {
        this.c2.put((Object)k1, (Object)"value1");
        this.c2.put((Object)k2, (Object)"value2");
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
    }

    private <T> void assertRetVal(T expected, T retVal) {
        if (this.testRetVals) {
            AssertJUnit.assertEquals(expected, retVal);
        }
    }

    private void assertTransactionOriginatorDataAfterRollback(Cache<Object, String> cache, MagicKey k1, MagicKey k2) {
        if (this.testRetVals) {
            this.assertIsInL1(cache, k1);
            this.assertIsInL1(cache, k2);
        } else {
            this.assertIsNotInL1(cache, k1);
            this.assertIsNotInL1(cache, k2);
        }
    }
}

