/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.InvalidationFailureTest")
public class InvalidationFailureTest
extends MultipleCacheManagersTest {
    private Object k0;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = InvalidationFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        config.clustering().l1().enable().hash().numOwners(1);
        config.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.createCluster(TestDataSCI.INSTANCE, config, 2);
        String cacheName = (String)this.manager(0).getCacheManagerConfiguration().defaultCacheName().get();
        this.manager(0).defineConfiguration("second", config.build());
        this.manager(1).defineConfiguration("second", config.build());
        this.manager(0).startCaches(new String[]{cacheName, "second"});
        this.manager(1).startCaches(new String[]{cacheName, "second"});
        this.waitForClusterToForm(cacheName, "second");
        this.cache(0).put((Object)"k", (Object)"v");
        this.cache(0, "second").put((Object)"k", (Object)"v");
        assert (this.cache(1).get((Object)"k").equals("v"));
        assert (this.cache(1, "second").get((Object)"k").equals("v"));
        this.k0 = new MagicKey(this.cache(0));
    }

    public void testL1Invalidated() throws Exception {
        block11: {
            this.tm(1).begin();
            this.cache(1).put(this.k0, (Object)"v");
            this.cache(1, "second").put(this.k0, (Object)"v");
            assert (!this.lockManager(1).isLocked(this.k0));
            assert (!this.lockManager(1, "second").isLocked(this.k0));
            Transaction transaction = this.tm(1).suspend();
            this.tm(0).begin();
            log.info((Object)"Before the put");
            this.cache(0, "second").put(this.k0, (Object)"v1");
            this.cache(0).put(this.k0, (Object)"v2");
            try {
                this.tm(0).commit();
                log.info((Object)"After the Commit");
            }
            catch (Exception e) {
                log.error((Object)"Error during commit", (Throwable)e);
                assert (false) : "this should not fail even if the invalidation does";
            }
            finally {
                this.tm(1).resume(transaction);
                this.tm(1).rollback();
                assert (!this.lockManager(0).isLocked(this.k0));
                assert (!this.lockManager(0, "second").isLocked(this.k0));
                assert (!this.lockManager(1).isLocked(this.k0));
                if ($assertionsDisabled || !this.lockManager(1, "second").isLocked(this.k0)) break block11;
                throw new AssertionError();
            }
        }
    }
}

