/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.SingleOwnerAndAsyncMethodsWithTxTest")
public class SingleOwnerAndAsyncMethodsWithTxTest
extends BaseDistFunctionalTest<Object, String> {
    public SingleOwnerAndAsyncMethodsWithTxTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.numOwners = 1;
        this.transactional = true;
        this.l1CacheEnabled = true;
        this.lockTimeout = 5;
        this.lockingMode = LockingMode.PESSIMISTIC;
    }

    public void testAsyncGetsWithinTx(Method m) throws Exception {
        String k = TestingUtil.k(m);
        String v = TestingUtil.v(m);
        Cache<Object, String> ownerCache = this.getOwner(k);
        Cache<Object, String> nonOwnerCache = this.getNonOwner(k);
        ownerCache.put((Object)k, (Object)v);
        TransactionManager tm = this.getTransactionManager(nonOwnerCache);
        tm.begin();
        CompletableFuture f = nonOwnerCache.getAsync((Object)k);
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertEquals((String)v, (String)((String)f.get()));
        CompletableFuture allF = nonOwnerCache.getAllAsync(Collections.singleton(k));
        AssertJUnit.assertNotNull((Object)allF);
        AssertJUnit.assertEquals(Collections.singletonMap(k, v), allF.get());
        nonOwnerCache.put((Object)k, (Object)TestingUtil.v(m, 2));
        tm.commit();
        f = nonOwnerCache.getAsync((Object)k);
        AssertJUnit.assertNotNull((Object)f);
        AssertJUnit.assertEquals((String)TestingUtil.v(m, 2), (String)((String)f.get()));
        allF = nonOwnerCache.getAllAsync(Collections.singleton(k));
        AssertJUnit.assertNotNull((Object)allF);
        AssertJUnit.assertEquals(Collections.singletonMap(k, TestingUtil.v(m, 2)), allF.get());
    }

    public void testAsyncGetToL1AndConcurrentModification(Method m) throws Throwable {
        this.modifyConcurrently(m, this.getNonOwner(TestingUtil.k(m)), false);
    }

    public void testAsyncGetWithForceWriteLockFlag(Method m) throws Throwable {
        this.modifyConcurrently(m, this.getOwner(TestingUtil.k(m)), true);
    }

    private void modifyConcurrently(Method m, Cache cache, boolean withFlag) throws Throwable {
        block4: {
            String k = TestingUtil.k(m);
            String v = TestingUtil.v(m);
            Cache<Object, String> ownerCache = this.getOwner(k);
            ownerCache.put((Object)k, (Object)v);
            CountDownLatch getAsynclatch = new CountDownLatch(1);
            CountDownLatch putLatch = new CountDownLatch(1);
            Callable<Void> c1 = () -> {
                Cache localCache = cache;
                TransactionManager tm = this.getTransactionManager(localCache);
                tm.begin();
                if (withFlag) {
                    localCache = cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK);
                }
                CompletableFuture f = localCache.getAsync((Object)k);
                CompletableFuture allF = localCache.getAllAsync(Collections.singleton(k));
                AssertJUnit.assertNotNull((Object)f);
                AssertJUnit.assertEquals((String)v, (String)((String)f.get()));
                AssertJUnit.assertNotNull((Object)allF);
                AssertJUnit.assertEquals(Collections.singletonMap(k, v), allF.get());
                putLatch.countDown();
                getAsynclatch.await();
                tm.commit();
                return null;
            };
            Callable<Void> c2 = () -> {
                putLatch.await();
                TransactionManager tm = this.getTransactionManager(cache);
                tm.begin();
                try {
                    cache.put((Object)k, (Object)TestingUtil.v(m, 1));
                    getAsynclatch.countDown();
                    AssertJUnit.assertFalse((String)"Put operation should have timed out if the get operation acquires a write lock", (boolean)withFlag);
                }
                catch (TimeoutException e) {
                    tm.setRollbackOnly();
                    getAsynclatch.countDown();
                    throw e;
                }
                finally {
                    if (tm.getStatus() == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                }
                return null;
            };
            Future<Void> f1 = this.fork(c1);
            Future<Void> f2 = this.fork(c2);
            f1.get();
            try {
                f2.get();
                assert (!withFlag) : "Should throw a TimeoutException if the get operation acquired a lock";
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionError) {
                    throw cause;
                }
                if ($assertionsDisabled || e.getCause() instanceof TimeoutException) break block4;
                throw new AssertionError((Object)String.format("The exception should be a TimeoutException but instead was %s", e.getCause()));
            }
        }
    }

    protected Cache<Object, String> getOwner(Object key) {
        return this.getOwners(key)[0];
    }

    protected Cache<Object, String> getNonOwner(Object key) {
        return this.getNonOwners(key)[0];
    }

    @Override
    public Cache<Object, String>[] getOwners(Object key) {
        return this.getOwners(key, 1);
    }

    @Override
    public Cache<Object, String>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 1);
    }
}

