/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.RemoteException;
import org.infinispan.test.data.BrokenMarshallingPojo;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.SingleOwnerTest")
public class SingleOwnerTest
extends BaseDistFunctionalTest<Object, String> {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheName = "dist";
        this.configuration = SingleOwnerTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        if (!this.testRetVals) {
            this.configuration.unsafe().unreliableReturnValues(true);
            this.configuration.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        this.configuration.clustering().remoteTimeout(3L, TimeUnit.SECONDS);
        this.configuration.clustering().hash().numOwners(1);
        this.configuration.locking().lockAcquisitionTimeout(45L, TimeUnit.SECONDS);
        this.createClusteredCaches(2, this.cacheName, this.configuration);
        this.caches = this.caches(this.cacheName);
        this.c1 = (Cache)this.caches.get(0);
        this.c2 = (Cache)this.caches.get(1);
        this.cacheAddresses = new ArrayList(2);
        for (Cache cache : this.caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            this.cacheAddresses.add(cacheManager.getAddress());
        }
        this.waitForClusterToForm(this.cacheName);
    }

    public void testPutOnKeyOwner() {
        Cache<K, V>[] caches = this.getOwners("mykey", 1);
        assert (caches.length == 1);
        Cache ownerCache = caches[0];
        ownerCache.put((Object)"mykey", new Object());
    }

    public void testClearOnKeyOwner() {
        Cache<K, V>[] caches = this.getOwners("mykey", 1);
        assert (caches.length == 1);
        Cache ownerCache = caches[0];
        ownerCache.clear();
    }

    public void testRetrieveNonSerializableValueFromNonOwner() {
        Cache<K, V>[] owners = this.getOwners("yourkey", 1);
        Cache<K, V>[] nonOwners = this.getNonOwners("yourkey", 1);
        assert (owners.length == 1);
        assert (nonOwners.length == 1);
        Cache ownerCache = owners[0];
        Cache nonOwnerCache = nonOwners[0];
        ownerCache.put((Object)"yourkey", new Object());
        try {
            nonOwnerCache.get((Object)"yourkey");
            AssertJUnit.fail((String)"Should have failed with a org.infinispan.commons.marshall.MarshallingException");
        }
        catch (RemoteException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof MarshallingException));
        }
    }

    public void testErrorWhenRetrievingKeyFromNonOwner() {
        log.trace((Object)"Before test");
        Cache<K, V>[] owners = this.getOwners("diffkey", 1);
        Cache<K, V>[] nonOwners = this.getNonOwners("diffkey", 1);
        assert (owners.length == 1);
        assert (nonOwners.length == 1);
        Cache ownerCache = owners[0];
        Cache nonOwnerCache = nonOwners[0];
        ownerCache.put((Object)"diffkey", (Object)new BrokenMarshallingPojo());
        Exceptions.expectException(RemoteException.class, MarshallingException.class, () -> nonOwnerCache.get((Object)"diffkey"));
    }
}

