/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.nio.file.Paths;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.ch.ZeroCapacityAdministrationTest")
public class ZeroCapacityAdministrationTest
extends MultipleCacheManagersTest {
    private static final String TEST_DIR = CommonsTestingUtil.tmpDirectory((String[])new String[]{ZeroCapacityAdministrationTest.class.getSimpleName()});
    private EmbeddedCacheManager node1;
    private EmbeddedCacheManager zeroCapacityNode;

    @Override
    protected void createCacheManagers() throws Throwable {
        String state1 = Paths.get(TEST_DIR, "1").toString();
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1);
        this.node1 = this.addClusterEnabledCacheManager(global1, new ConfigurationBuilder());
        String zeroState = Paths.get(TEST_DIR, "zero").toString();
        GlobalConfigurationBuilder globalZero = this.statefulGlobalBuilder(zeroState).zeroCapacityNode(true);
        this.zeroCapacityNode = this.addClusterEnabledCacheManager(globalZero, new ConfigurationBuilder());
        this.waitForClusterToForm();
    }

    public void testDefineClusterConfiguration() {
        Configuration config = new ConfigurationBuilder().build();
        this.zeroCapacityNode.administration().createCache("zero-cache", config);
        this.zeroCapacityNode.administration().createTemplate("zero-template", config);
        AssertJUnit.assertNotNull((Object)this.node1.getCache("zero-cache"));
        AssertJUnit.assertNotNull((Object)this.node1.getCacheConfiguration("zero-template"));
    }

    private GlobalConfigurationBuilder statefulGlobalBuilder(String stateDirectory) {
        Util.recursiveFileRemove((String)stateDirectory);
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).sharedPersistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        return global;
    }
}

