/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.AffinityTaggedKey;
import org.infinispan.distribution.ch.DistributionSerializationContextImpl;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.AffinityPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.ch.AffinityPartitionerTest")
public class AffinityPartitionerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.addNodes(2);
    }

    private void addNodes(int count) {
        ConfigurationBuilder conf = this.getConfigurationBuilder();
        this.createCluster(new DistributionSerializationContextImpl(), conf, count);
        this.waitForClusterToForm();
    }

    @Test
    public void testAffinityPartitioner() throws Exception {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache();
        IntStream.range(0, 10).boxed().forEach(num -> cache.put((Object)new AffinityKey((int)num), (Object)"value"));
        this.addNodes(1);
        this.cacheManagers.stream().map(cm -> cm.getCache().getAdvancedCache()).forEach(advancedCache -> {
            LocalizedCacheTopology cacheTopology = advancedCache.getDistributionManager().getCacheTopology();
            advancedCache.getDataContainer().forEach(ice -> {
                Object key = ice.getKey();
                int keySegmentId = ((AffinityKey)key).segmentId;
                AssertJUnit.assertEquals((int)cacheTopology.getSegment(key), (int)keySegmentId);
            });
        });
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder conf = AffinityPartitionerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        conf.clustering().hash().keyPartitioner((KeyPartitioner)new AffinityPartitioner()).numSegments(10).numOwners(1);
        return conf;
    }

    @AutoProtoSchemaBuilder(includeClasses={AffinityKey.class}, schemaFileName="core.distribution.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.distribution", service=false)
    static interface DistributionSerializationContext
    extends SerializationContextInitializer {
    }

    public static class AffinityKey
    implements AffinityTaggedKey {
        @ProtoField(number=1, defaultValue="0")
        final int segmentId;

        @ProtoFactory
        AffinityKey(int segmentId) {
            this.segmentId = segmentId;
        }

        public int getAffinitySegmentId() {
            return this.segmentId;
        }
    }
}

