/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.ch.DefaultConsistentHashFactoryTest")
public class DefaultConsistentHashFactoryTest
extends AbstractInfinispanTest {
    public static final int[] NUM_SEGMENTS = new int[]{1, 2, 4, 8, 16, 60, 256, 512};
    public static final int[] NUM_NODES = new int[]{1, 2, 3, 4, 7, 10, 100};
    public static final int[] NUM_OWNERS = new int[]{1, 2, 3, 5};
    public static final float[][] CAPACITY_FACTORS = new float[][]{{1.0f}, {2.0f}, {1.0f, 100.0f}, {2.0f, 0.0f, 1.0f}};
    public static final int[][] NODE_CHANGES = new int[][]{{1, 0}, {2, 0}, {0, 1}, {0, 2}, {2, 1}, {1, 2}, {10, 0}, {0, 10}};
    private int iterationCount = 0;

    protected ConsistentHashFactory<DefaultConsistentHash> createConsistentHashFactory() {
        return new DefaultConsistentHashFactory();
    }

    public void testConsistentHashDistribution() {
        ConsistentHashFactory<DefaultConsistentHash> chf = this.createConsistentHashFactory();
        for (int nn : NUM_NODES) {
            ArrayList<Address> nodes = new ArrayList<Address>(nn);
            for (int j = 0; j < nn; ++j) {
                nodes.add(new TestAddress(j, "TA"));
            }
            for (int ns : NUM_SEGMENTS) {
                if (nn >= ns) continue;
                for (int no : NUM_OWNERS) {
                    for (float[] lf : CAPACITY_FACTORS) {
                        HashMap<Address, Float> lfMap = null;
                        if (lf != null) {
                            lfMap = new HashMap<Address, Float>();
                            for (int i = 0; i < nn; ++i) {
                                lfMap.put((Address)nodes.get(i), Float.valueOf(lf[i % lf.length]));
                            }
                        }
                        this.testConsistentHashModifications(chf, nodes, ns, no, lfMap);
                    }
                }
            }
        }
    }

    private void testConsistentHashModifications(ConsistentHashFactory<DefaultConsistentHash> chf, List<Address> nodes, int ns, int no, Map<Address, Float> capacityFactors) {
        log.tracef("Creating consistent hash with ns=%d, no=%d, members=(%d)%s", new Object[]{ns, no, nodes.size(), this.membersString(nodes, capacityFactors)});
        DefaultConsistentHash baseCH = (DefaultConsistentHash)chf.create(no, ns, nodes, capacityFactors);
        AssertJUnit.assertEquals((Object)baseCH.getCapacityFactors(), capacityFactors);
        this.checkDistribution(baseCH, capacityFactors);
        List baseMembers = baseCH.getMembers();
        AssertJUnit.assertSame((Object)baseCH, (Object)chf.updateMembers((ConsistentHash)baseCH, baseMembers, capacityFactors));
        AssertJUnit.assertSame((Object)baseCH, (Object)chf.rebalance((ConsistentHash)baseCH));
        int nodeIndex = baseMembers.size();
        for (int[] nodeChange : NODE_CHANGES) {
            int k;
            int nodesToAdd = nodeChange[0];
            int nodesToRemove = nodeChange[1];
            if (nodesToRemove > baseMembers.size() || nodesToRemove == baseMembers.size() && nodesToAdd == 0) break;
            ArrayList<Address> newMembers = new ArrayList<Address>(baseMembers);
            HashMap<Address, Float> newCapacityFactors = capacityFactors != null ? new HashMap<Address, Float>(capacityFactors) : null;
            for (k = 0; k < nodesToRemove; ++k) {
                int indexToRemove = Math.abs(MurmurHash3.getInstance().hash(k) % newMembers.size());
                if (newCapacityFactors != null) {
                    newCapacityFactors.remove(newMembers.get(indexToRemove));
                }
                newMembers.remove(indexToRemove);
            }
            for (k = 0; k < nodesToAdd; ++k) {
                TestAddress address = new TestAddress(nodeIndex++, "TA");
                newMembers.add(address);
                if (newCapacityFactors == null) continue;
                newCapacityFactors.put(address, capacityFactors.get(baseMembers.get(k % baseMembers.size())));
            }
            log.tracef("Rebalance iteration %d, members=(%d)%s", this.iterationCount, newMembers.size(), (Object)this.membersString(newMembers, newCapacityFactors));
            baseCH = this.rebalanceIteration(chf, baseCH, nodesToAdd, nodesToRemove, newMembers, newCapacityFactors);
            baseMembers = baseCH.getMembers();
            capacityFactors = newCapacityFactors;
            ++this.iterationCount;
        }
    }

    private String membersString(List<Address> newMembers, Map<Address, Float> newCapacityFactors) {
        return newMembers.stream().map(a -> String.format("%s * %.1f", a, Float.valueOf(this.getCapacityFactor(newCapacityFactors, (Address)a)))).collect(Collectors.joining(", ", "[", "]"));
    }

    private float getCapacityFactor(Map<Address, Float> capacityFactors, Address a) {
        return capacityFactors != null ? capacityFactors.get(a).floatValue() : 1.0f;
    }

    private DefaultConsistentHash rebalanceIteration(ConsistentHashFactory<DefaultConsistentHash> chf, DefaultConsistentHash baseCH, int nodesToAdd, int nodesToRemove, List<Address> newMembers, Map<Address, Float> lfMap) {
        int actualNumOwners = this.computeActualNumOwners(baseCH.getNumOwners(), newMembers, lfMap);
        DefaultConsistentHash updatedMembersCH = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)baseCH, newMembers, lfMap);
        AssertJUnit.assertEquals(lfMap, (Object)updatedMembersCH.getCapacityFactors());
        if (nodesToRemove > 0) {
            for (int l = 0; l < updatedMembersCH.getNumSegments(); ++l) {
                AssertJUnit.assertTrue((updatedMembersCH.locateOwnersForSegment(l).size() > 0 ? 1 : 0) != 0);
                AssertJUnit.assertTrue((updatedMembersCH.locateOwnersForSegment(l).size() <= actualNumOwners ? 1 : 0) != 0);
            }
        }
        long startNanos = System.nanoTime();
        DefaultConsistentHash rebalancedCH = (DefaultConsistentHash)chf.rebalance((ConsistentHash)updatedMembersCH);
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        if (durationMillis >= 5L) {
            log.tracef("Rebalance took %dms", durationMillis);
        }
        this.checkDistribution(rebalancedCH, lfMap);
        for (int l = 0; l < rebalancedCH.getNumSegments(); ++l) {
            AssertJUnit.assertTrue((rebalancedCH.locateOwnersForSegment(l).size() >= actualNumOwners ? 1 : 0) != 0);
        }
        this.checkMovedSegments(baseCH, rebalancedCH, nodesToAdd, nodesToRemove);
        DefaultConsistentHash unionCH = (DefaultConsistentHash)chf.union((ConsistentHash)updatedMembersCH, (ConsistentHash)rebalancedCH);
        for (int l = 0; l < updatedMembersCH.getNumSegments(); ++l) {
            AssertJUnit.assertTrue((boolean)unionCH.locateOwnersForSegment(l).containsAll(updatedMembersCH.locateOwnersForSegment(l)));
            AssertJUnit.assertTrue((boolean)unionCH.locateOwnersForSegment(l).containsAll(rebalancedCH.locateOwnersForSegment(l)));
        }
        AssertJUnit.assertEquals((int)baseCH.getNumSegments(), (int)rebalancedCH.getNumSegments());
        AssertJUnit.assertEquals((int)baseCH.getNumOwners(), (int)rebalancedCH.getNumOwners());
        AssertJUnit.assertEquals(newMembers, (Object)rebalancedCH.getMembers());
        baseCH = rebalancedCH;
        return baseCH;
    }

    protected void checkDistribution(DefaultConsistentHash ch, Map<Address, Float> lfMap) {
        int numSegments = ch.getNumSegments();
        List nodes = ch.getMembers();
        int numNodesWithLoad = this.nodesWithLoad(nodes, lfMap);
        int actualNumOwners = this.computeActualNumOwners(ch.getNumOwners(), nodes, lfMap);
        OwnershipStatistics stats = new OwnershipStatistics((ConsistentHash)ch, nodes);
        for (int s = 0; s < numSegments; ++s) {
            List owners = ch.locateOwnersForSegment(s);
            AssertJUnit.assertEquals((int)actualNumOwners, (int)owners.size());
            for (int i = 1; i < owners.size(); ++i) {
                Address owner = (Address)owners.get(i);
                AssertJUnit.assertEquals((String)"Found the same owner twice in the owners list", (int)i, (int)owners.indexOf(owner));
            }
        }
        float totalCapacity = this.computeTotalCapacity(nodes, lfMap);
        Map<Address, Float> expectedOwnedMap = this.computeExpectedOwned(numSegments, numNodesWithLoad, actualNumOwners, nodes, lfMap);
        for (Address node : nodes) {
            float capacityFactor = this.getCapacityFactor(lfMap, node);
            float expectedPrimaryOwned = this.expectedPrimaryOwned(numSegments, numNodesWithLoad, totalCapacity, capacityFactor);
            int minPrimaryOwned = (int)Math.floor(this.minOwned(numSegments, 1, numNodesWithLoad, expectedPrimaryOwned));
            int maxPrimaryOwned = (int)Math.ceil(this.maxOwned(numSegments, 1, numNodesWithLoad, expectedPrimaryOwned));
            int primaryOwned = stats.getPrimaryOwned(node);
            if (primaryOwned < minPrimaryOwned || maxPrimaryOwned < primaryOwned) {
                AssertJUnit.fail((String)String.format("Primary owned (%d) should have been between %d and %d", primaryOwned, minPrimaryOwned, maxPrimaryOwned));
            }
            float expectedOwned = expectedOwnedMap.get(node).floatValue();
            int minOwned = (int)Math.floor(this.minOwned(numSegments, actualNumOwners, numNodesWithLoad, expectedOwned));
            int maxOwned = (int)Math.ceil(this.maxOwned(numSegments, actualNumOwners, numNodesWithLoad, expectedOwned));
            int owned = stats.getOwned(node);
            if (owned >= minOwned && maxOwned >= owned) continue;
            AssertJUnit.fail((String)String.format("Owned (%d) should have been between %d and %d", owned, minOwned, maxOwned));
        }
    }

    public int computeActualNumOwners(int numOwners, List<Address> members, Map<Address, Float> capacityFactors) {
        int nodesWithLoad = this.nodesWithLoad(members, capacityFactors);
        return Math.min(numOwners, nodesWithLoad);
    }

    int nodesWithLoad(List<Address> members, Map<Address, Float> capacityFactors) {
        if (capacityFactors == null) {
            return members.size();
        }
        int nodesWithLoad = 0;
        for (Address node : members) {
            if (capacityFactors.get(node).floatValue() == 0.0f) continue;
            ++nodesWithLoad;
        }
        return nodesWithLoad;
    }

    protected float expectedPrimaryOwned(int numSegments, int numNodes, float totalCapacity, float nodeLoad) {
        return (float)numSegments * nodeLoad / totalCapacity;
    }

    protected Map<Address, Float> computeExpectedOwned(int numSegments, int numNodes, int actualNumOwners, Collection<Address> nodes, Map<Address, Float> capacityFactors) {
        LinkedHashMap<Address, Float> expectedOwned = new LinkedHashMap<Address, Float>(numNodes * 2);
        float expected = Math.min((float)numSegments, (float)numSegments * (float)actualNumOwners / (float)numNodes);
        for (Address node : nodes) {
            expectedOwned.put(node, Float.valueOf(expected));
        }
        if (capacityFactors == null) {
            return expectedOwned;
        }
        ArrayList<Address> sortedNodes = new ArrayList<Address>(nodes);
        sortedNodes.sort((o1, o2) -> Float.compare(((Float)capacityFactors.get(o2)).floatValue(), ((Float)capacityFactors.get(o1)).floatValue()));
        float totalCapacity = this.computeTotalCapacity(nodes, capacityFactors);
        int remainingCopies = actualNumOwners * numSegments;
        for (Address node : sortedNodes) {
            float nodeSegments;
            float nodeLoad = capacityFactors.get(node).floatValue();
            if ((float)remainingCopies * nodeLoad / totalCapacity > (float)numSegments) {
                nodeSegments = numSegments;
                totalCapacity -= nodeLoad;
                remainingCopies = (int)((float)remainingCopies - nodeSegments);
            } else {
                nodeSegments = nodeLoad != 0.0f ? (float)remainingCopies * nodeLoad / totalCapacity : 0.0f;
            }
            expectedOwned.put(node, Float.valueOf(nodeSegments));
        }
        return expectedOwned;
    }

    protected float maxOwned(int numSegments, int actualNumOwners, int numNodes, float expectedOwned) {
        return expectedOwned + (float)(numNodes - 1) + 0.01f * expectedOwned;
    }

    protected float minOwned(int numSegments, int actualNumOwners, int numNodes, float expectedOwned) {
        return expectedOwned - Math.max(1.0f, (float)(numSegments * actualNumOwners) / expectedOwned * (float)numNodes);
    }

    private float computeTotalCapacity(Collection<Address> nodes, Map<Address, Float> capacityFactors) {
        if (capacityFactors == null) {
            return nodes.size();
        }
        float totalCapacity = 0.0f;
        for (Address node : nodes) {
            totalCapacity += capacityFactors.get(node).floatValue();
        }
        return totalCapacity;
    }

    protected float allowedExtraMoves(DefaultConsistentHash oldCH, DefaultConsistentHash newCH, int joinerSegments, int leaverSegments) {
        return Math.max(1.0f, 0.1f * (float)oldCH.getNumOwners() * (float)oldCH.getNumSegments());
    }

    private void checkMovedSegments(DefaultConsistentHash oldCH, DefaultConsistentHash newCH, int nodesAdded, int nodesRemoved) {
        double acceptablePrimarySwitchedWithBackup;
        int numSegments = oldCH.getNumSegments();
        int numOwners = oldCH.getNumOwners();
        List oldMembers = oldCH.getMembers();
        List newMembers = newCH.getMembers();
        HashSet commonMembers = new HashSet(oldMembers);
        commonMembers.retainAll(newMembers);
        int leaverSegments = 0;
        for (Object node : oldMembers) {
            if (commonMembers.contains(node)) continue;
            leaverSegments += oldCH.getSegmentsForOwner((Address)node).size();
        }
        int joinerSegments = 0;
        for (Address node : newMembers) {
            if (commonMembers.contains(node)) continue;
            joinerSegments += newCH.getSegmentsForOwner(node).size();
        }
        int commonMembersAddedSegments = 0;
        int commonMembersRemovedSegments = 0;
        int primarySwitchedWithBackup = 0;
        for (int segment = 0; segment < numSegments; ++segment) {
            List oldOwners = oldCH.locateOwnersForSegment(segment);
            List newOwners = newCH.locateOwnersForSegment(segment);
            for (Address newOwner : newOwners) {
                if (!commonMembers.contains(newOwner) || oldOwners.contains(newOwner)) continue;
                ++commonMembersAddedSegments;
            }
            for (Address oldOwner : oldOwners) {
                if (!commonMembers.contains(oldOwner) || newOwners.contains(oldOwner)) continue;
                ++commonMembersRemovedSegments;
            }
            Address oldPrimary = (Address)oldOwners.get(0);
            Address newPrimary = (Address)newOwners.get(0);
            if (newPrimary.equals(oldPrimary) || !newOwners.contains(oldPrimary) || !oldOwners.contains(newPrimary)) continue;
            ++primarySwitchedWithBackup;
        }
        int movedSegments = Math.max(0, commonMembersAddedSegments - leaverSegments);
        int movedSegments2 = Math.max(0, commonMembersRemovedSegments - joinerSegments);
        AssertJUnit.assertEquals((int)movedSegments, (int)movedSegments2);
        int expectedExtraMoves = (int)Math.ceil(this.allowedExtraMoves(oldCH, newCH, joinerSegments, leaverSegments));
        if (movedSegments > expectedExtraMoves / 2) {
            log.tracef("%d of %d*%d extra segments moved, %fx of allowed (%d), %d leavers had %d, %d joiners have %d", new Object[]{movedSegments, numOwners, numSegments, Float.valueOf((float)movedSegments / (float)expectedExtraMoves), expectedExtraMoves, nodesRemoved, leaverSegments, nodesAdded, joinerSegments});
        }
        if (movedSegments > expectedExtraMoves) {
            AssertJUnit.fail((String)String.format("Two many moved segments between %s and %s: expected %d, got %d", oldCH, newCH, expectedExtraMoves, movedSegments));
        }
        if ((double)primarySwitchedWithBackup > Math.ceil(0.05 * (double)numSegments)) {
            log.tracef("Primary owner switched with backup for %d segments of %d", primarySwitchedWithBackup, numSegments);
        }
        if ((double)primarySwitchedWithBackup > (acceptablePrimarySwitchedWithBackup = Math.ceil(0.5 * (double)(joinerSegments + leaverSegments) / (double)numOwners * (double)numSegments))) {
            AssertJUnit.fail((String)String.format("Primary owner switched with backup owner for too many segments: %d of %d", primarySwitchedWithBackup, numSegments));
        }
    }

    public void testNullCapacityFactors() {
        ConsistentHashFactory<DefaultConsistentHash> chf = this.createConsistentHashFactory();
        TestAddress A2 = new TestAddress(0, "A");
        TestAddress B2 = new TestAddress(1, "B");
        TestAddress C2 = new TestAddress(2, "C");
        TestAddress D4 = new TestAddress(3, "D");
        HashMap<TestAddress, Float> cf = new HashMap<TestAddress, Float>();
        cf.put(A2, Float.valueOf(1.0f));
        cf.put(B2, Float.valueOf(1.0f));
        cf.put(C2, Float.valueOf(1.0f));
        cf.put(D4, Float.valueOf(1.0f));
        DefaultConsistentHash ch1 = (DefaultConsistentHash)chf.create(2, 60, Arrays.asList(A2), cf);
        DefaultConsistentHash ch1NoCF = (DefaultConsistentHash)chf.create(2, 60, Arrays.asList(A2), null);
        AssertJUnit.assertEquals((Object)ch1, (Object)ch1NoCF);
        DefaultConsistentHash ch2 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch1, Arrays.asList(A2, B2), cf);
        ch2 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch2);
        DefaultConsistentHash ch2NoCF = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch1, Arrays.asList(A2, B2), null);
        ch2NoCF = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch2NoCF);
        AssertJUnit.assertEquals((Object)ch2, (Object)ch2NoCF);
        DefaultConsistentHash ch3 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch2, Arrays.asList(A2, B2, C2), cf);
        ch3 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch3);
        DefaultConsistentHash ch3NoCF = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch2, Arrays.asList(A2, B2, C2), null);
        ch3NoCF = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch3NoCF);
        AssertJUnit.assertEquals((Object)ch3, (Object)ch3NoCF);
        DefaultConsistentHash ch4 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch3, Arrays.asList(A2, B2, C2, D4), cf);
        ch4 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch4);
        DefaultConsistentHash ch4NoCF = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch3, Arrays.asList(A2, B2, C2, D4), null);
        ch4NoCF = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch4NoCF);
        AssertJUnit.assertEquals((Object)ch4, (Object)ch4NoCF);
    }

    public void testDifferentCapacityFactors() {
        ConsistentHashFactory<DefaultConsistentHash> chf = this.createConsistentHashFactory();
        TestAddress A2 = new TestAddress(0, "A");
        TestAddress B2 = new TestAddress(1, "B");
        TestAddress C2 = new TestAddress(2, "C");
        TestAddress D4 = new TestAddress(3, "D");
        HashMap<Address, Float> cf = new HashMap<Address, Float>();
        cf.put(A2, Float.valueOf(1.0f));
        cf.put(B2, Float.valueOf(1.0f));
        cf.put(C2, Float.valueOf(1.0f));
        cf.put(D4, Float.valueOf(100.0f));
        DefaultConsistentHash ch1 = (DefaultConsistentHash)chf.create(2, 60, Arrays.asList(A2), cf);
        this.checkDistribution(ch1, cf);
        DefaultConsistentHash ch2 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch1, Arrays.asList(A2, B2), cf);
        ch2 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch2);
        this.checkDistribution(ch2, cf);
        DefaultConsistentHash ch3 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch2, Arrays.asList(A2, B2, C2), cf);
        ch3 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch3);
        this.checkDistribution(ch3, cf);
        DefaultConsistentHash ch4 = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch3, Arrays.asList(A2, B2, C2, D4), cf);
        ch4 = (DefaultConsistentHash)chf.rebalance((ConsistentHash)ch4);
        this.checkDistribution(ch4, cf);
    }
}

