/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.group.Group;
import org.infinispan.distribution.groups.GroupTestsSCIImpl;
import org.infinispan.distribution.groups.StateTransferGetGroupKeysTest;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;

public abstract class BaseUtilGroupTest
extends MultipleCacheManagersTest {
    protected static final String GROUP = "test-group";
    protected final TestCacheFactory factory;

    protected BaseUtilGroupTest(TestCacheFactory factory) {
        this.factory = factory;
        this.cacheMode = CacheMode.DIST_SYNC;
    }

    @Override
    protected String parameters() {
        String parameters = super.parameters();
        if (parameters == null) {
            return "[" + (Object)((Object)this.factory) + "]";
        }
        return "[" + (Object)((Object)this.factory) + ", " + parameters.substring(1);
    }

    protected static GroupKey key(int index) {
        return new GroupKey(GROUP, index);
    }

    protected static String value(int index) {
        return "v" + index;
    }

    protected abstract void resetCaches(List<Cache<GroupKey, String>> var1);

    protected static boolean isGroupOwner(Cache<?, ?> cache, String groupName) {
        return TestingUtil.extractComponent(cache, DistributionManager.class).getCacheTopology().isWriteOwner((Object)groupName);
    }

    protected static AdvancedCache<GroupKey, String> extractTargetCache(TestCache testCache) {
        if (BaseUtilGroupTest.isGroupOwner(testCache.testCache, GROUP)) {
            return testCache.testCache;
        }
        return testCache.primaryOwner.getAdvancedCache();
    }

    protected static void initCache(Cache<GroupKey, String> cache) {
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)BaseUtilGroupTest.key(i), (Object)BaseUtilGroupTest.value(i));
            cache.put((Object)new GroupKey("other-group", i), (Object)BaseUtilGroupTest.value(i));
        }
    }

    protected static Map<GroupKey, String> createMap(int from, int to) {
        HashMap<GroupKey, String> map = new HashMap<GroupKey, String>();
        for (int i = from; i < to; ++i) {
            map.put(BaseUtilGroupTest.key(i), BaseUtilGroupTest.value(i));
        }
        return map;
    }

    protected final TestCache createTestCacheAndReset(String groupName, List<Cache<GroupKey, String>> cacheList) {
        this.resetCaches(cacheList);
        return this.factory.create(groupName, cacheList);
    }

    @AutoProtoSchemaBuilder(includeClasses={GroupKey.class, CacheMode.class, StateTransferGetGroupKeysTest.CustomConsistentHashFactory.class}, schemaFileName="test.core.GroupTestsSCI.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.GroupTestsSCI", service=false)
    static interface GroupTestsSCI
    extends SerializationContextInitializer {
        public static final GroupTestsSCI INSTANCE = new GroupTestsSCIImpl();
    }

    public static class TestCache {
        public final Cache<GroupKey, String> primaryOwner;
        public final AdvancedCache<GroupKey, String> testCache;

        public TestCache(Cache<GroupKey, String> primaryOwner, AdvancedCache<GroupKey, String> testCache) {
            this.primaryOwner = primaryOwner;
            this.testCache = testCache;
        }
    }

    public static class GroupKey {
        @ProtoField(value=1)
        final String group;
        @ProtoField(number=2, defaultValue="0")
        final int key;

        @ProtoFactory
        GroupKey(String group, int key) {
            this.group = group;
            this.key = key;
        }

        @Group
        public String getGroup() {
            return this.group;
        }

        public int getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            return this.key == groupKey.key && this.group.equals(groupKey.group);
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = 31 * result + this.key;
            return result;
        }

        public String toString() {
            return "GroupKey{group='" + this.group + '\'' + ", key=" + this.key + '}';
        }
    }

    public static enum TestCacheFactory {
        PRIMARY_OWNER{

            @Override
            public TestCache create(String groupName, List<Cache<GroupKey, String>> cacheList) {
                for (Cache<GroupKey, String> cache : cacheList) {
                    DistributionManager distributionManager = TestingUtil.extractComponent(cache, DistributionManager.class);
                    DistributionInfo distributionInfo = distributionManager.getCacheTopology().getDistribution((Object)groupName);
                    if (!distributionInfo.isPrimary()) continue;
                    return new TestCache(cache, (AdvancedCache<GroupKey, String>)cache.getAdvancedCache());
                }
                throw new IllegalStateException("didn't find a cache... should never happen!");
            }
        }
        ,
        BACKUP_OWNER{

            @Override
            public TestCache create(String groupName, List<Cache<GroupKey, String>> cacheList) {
                Cache<GroupKey, String> primaryOwner = null;
                AdvancedCache backupOwner = null;
                for (Cache<GroupKey, String> cache : cacheList) {
                    DistributionManager distributionManager = TestingUtil.extractComponent(cache, DistributionManager.class);
                    DistributionInfo distributionInfo = distributionManager.getCacheTopology().getDistribution((Object)groupName);
                    if (primaryOwner == null && distributionInfo.isPrimary()) {
                        primaryOwner = cache;
                    } else if (backupOwner == null && distributionInfo.isWriteOwner()) {
                        backupOwner = cache.getAdvancedCache();
                    }
                    if (primaryOwner == null || backupOwner == null) continue;
                    return new TestCache(primaryOwner, (AdvancedCache<GroupKey, String>)backupOwner);
                }
                throw new IllegalStateException("didn't find a cache... should never happen!");
            }
        }
        ,
        NON_OWNER{

            @Override
            public TestCache create(String groupName, List<Cache<GroupKey, String>> cacheList) {
                Cache<GroupKey, String> primaryOwner = null;
                AdvancedCache nonOwner = null;
                for (Cache<GroupKey, String> cache : cacheList) {
                    DistributionManager distributionManager = TestingUtil.extractComponent(cache, DistributionManager.class);
                    DistributionInfo distributionInfo = distributionManager.getCacheTopology().getDistribution((Object)groupName);
                    if (primaryOwner == null && distributionInfo.isPrimary()) {
                        primaryOwner = cache;
                    } else if (nonOwner == null && !distributionInfo.isWriteOwner()) {
                        nonOwner = cache.getAdvancedCache();
                    }
                    if (primaryOwner == null || nonOwner == null) continue;
                    return new TestCache(primaryOwner, (AdvancedCache<GroupKey, String>)nonOwner);
                }
                throw new IllegalStateException("didn't find a cache... should never happen!");
            }
        };


        public abstract TestCache create(String var1, List<Cache<GroupKey, String>> var2);
    }
}

