/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.groups.BaseUtilGroupTest;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.logging.Log;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.GetGroupKeysTest")
public class GetGroupKeysTest
extends BaseUtilGroupTest {
    protected static final String PERSISTENCE_CACHE = "persistence-cache";
    protected static final String PERSISTENCE_PASSIVATION_CACHE = "persistence-passivation-cache";
    protected final boolean transactional;

    @Override
    public Object[] factory() {
        return new Object[]{new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.BACKUP_OWNER), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.NON_OWNER), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER).cacheMode(CacheMode.SCATTERED_SYNC), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.NON_OWNER).cacheMode(CacheMode.SCATTERED_SYNC)};
    }

    public GetGroupKeysTest() {
        this(false, null);
    }

    protected GetGroupKeysTest(boolean transactional, BaseUtilGroupTest.TestCacheFactory factory) {
        super(factory);
        this.transactional = transactional;
    }

    public void testGetKeysInGroup() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistence() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistenceAndPassivation() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_PASSIVATION_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistenceAndSkipCacheLoader() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.withFlags(Flag.SKIP_CACHE_LOAD).getGroup("test-group");
        HashMap<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = new HashMap<BaseUtilGroupTest.GroupKey, String>();
        for (InternalCacheEntry entry : (DataContainer)TestingUtil.extractComponent(GetGroupKeysTest.extractTargetCache(testCache), InternalDataContainer.class)) {
            if (!((BaseUtilGroupTest.GroupKey)entry.getKey()).getGroup().equals("test-group")) continue;
            expectedGroupSet.put((BaseUtilGroupTest.GroupKey)entry.getKey(), (String)entry.getValue());
        }
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeyInGroupWithConcurrentActivation() throws TimeoutException, InterruptedException, ExecutionException {
        final BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_PASSIVATION_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        BlockCommandInterceptor interceptor = this.injectIfAbsent((Cache<?, ?>)GetGroupKeysTest.extractTargetCache(testCache));
        interceptor.open = false;
        Future<Map<BaseUtilGroupTest.GroupKey, String>> future = this.fork(new Callable<Map<BaseUtilGroupTest.GroupKey, String>>(){

            @Override
            public Map<BaseUtilGroupTest.GroupKey, String> call() throws Exception {
                return testCache.testCache.getGroup("test-group");
            }
        });
        interceptor.awaitCommandBlock();
        PersistenceManager persistenceManager = TestingUtil.extractComponent(GetGroupKeysTest.extractTargetCache(testCache), PersistenceManager.class);
        BaseUtilGroupTest.GroupKey groupKey = (BaseUtilGroupTest.GroupKey)Flowable.fromPublisher((Publisher)persistenceManager.publishKeys(null, (Predicate)PersistenceManager.AccessMode.BOTH)).take(1L).blockingSingle();
        AssertJUnit.assertNotNull((Object)GetGroupKeysTest.extractTargetCache(testCache).get((Object)groupKey));
        interceptor.unblockCommand();
        Map<BaseUtilGroupTest.GroupKey, String> groupKeySet = future.get();
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, groupKeySet);
    }

    public void testRemoveGroupKeys() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistence() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistenceAndPassivation() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_PASSIVATION_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistenceAndSkipCacheWriter() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.withFlags(Flag.SKIP_CACHE_STORE).removeGroup("test-group");
        ConcurrentHashMap expectedGroupSet2 = new ConcurrentHashMap();
        Flowable flowable = Flowable.fromPublisher((Publisher)TestingUtil.extractComponent(GetGroupKeysTest.extractTargetCache(testCache), PersistenceManager.class).publishEntries(true, true));
        flowable.filter(me -> "test-group".equals(((BaseUtilGroupTest.GroupKey)me.getKey()).getGroup())).blockingForEach(me -> expectedGroupSet2.put((BaseUtilGroupTest.GroupKey)me.getKey(), (String)me.getValue()));
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet = new HashMap<BaseUtilGroupTest.GroupKey, String>(expectedGroupSet2);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, BaseUtilGroupTest.GroupTestsSCI.INSTANCE, this.amendConfiguration(this.createConfigurationBuilder(this.transactional)));
        this.defineConfigurationOnAllManagers(PERSISTENCE_CACHE, this.amendConfiguration(this.createConfigurationBuilderWithPersistence(this.transactional, false)));
        this.waitForClusterToForm(PERSISTENCE_CACHE);
        this.defineConfigurationOnAllManagers(PERSISTENCE_PASSIVATION_CACHE, this.amendConfiguration(this.createConfigurationBuilderWithPersistence(this.transactional, true)));
        this.waitForClusterToForm(PERSISTENCE_PASSIVATION_CACHE);
    }

    protected ConfigurationBuilder amendConfiguration(ConfigurationBuilder builder) {
        return builder;
    }

    @Override
    protected final void resetCaches(List<Cache<BaseUtilGroupTest.GroupKey, String>> cacheList) {
        for (Cache<BaseUtilGroupTest.GroupKey, String> cache : cacheList) {
            AsyncInterceptorChain chain = cache.getAdvancedCache().getAsyncInterceptorChain();
            BlockCommandInterceptor interceptor = (BlockCommandInterceptor)chain.findInterceptorExtending(BlockCommandInterceptor.class);
            if (interceptor == null) continue;
            interceptor.reset();
        }
    }

    private ConfigurationBuilder createConfigurationBuilder(boolean transactional) {
        ConfigurationBuilder builder = GetGroupKeysTest.getDefaultClusteredCacheConfig(this.cacheMode, transactional);
        builder.clustering().stateTransfer().fetchInMemoryState(false);
        builder.clustering().hash().groups().enabled(true);
        return builder;
    }

    private ConfigurationBuilder createConfigurationBuilderWithPersistence(boolean transactional, boolean passivation) {
        ConfigurationBuilder builder = this.createConfigurationBuilder(transactional);
        if (passivation) {
            builder.memory().size(2L);
        }
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(passivation).addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(false);
        return builder;
    }

    private BlockCommandInterceptor injectIfAbsent(Cache<?, ?> cache) {
        log.debugf("Injecting BlockCommandInterceptor in %s", cache);
        AsyncInterceptorChain chain = cache.getAdvancedCache().getAsyncInterceptorChain();
        BlockCommandInterceptor interceptor = (BlockCommandInterceptor)chain.findInterceptorExtending(BlockCommandInterceptor.class);
        if (interceptor == null) {
            interceptor = new BlockCommandInterceptor(log);
            EntryWrappingInterceptor ewi = (EntryWrappingInterceptor)chain.findInterceptorExtending(EntryWrappingInterceptor.class);
            AssertJUnit.assertTrue((boolean)chain.addInterceptorAfter((AsyncInterceptor)interceptor, ewi.getClass()));
        }
        interceptor.reset();
        log.debugf("Injected BlockCommandInterceptor in %s. Interceptor=%s", cache, (Object)interceptor);
        return interceptor;
    }

    static class BlockCommandInterceptor
    extends DDAsyncInterceptor {
        private volatile CheckPoint checkPoint;
        private volatile boolean open;
        private final Log log;

        private BlockCommandInterceptor(Log log) {
            this.log = log;
            this.checkPoint = new CheckPoint();
        }

        public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
            this.log.debugf("Visit Get Keys in Group. Open? %s. CheckPoint=%s", (Object)this.open, (Object)this.checkPoint);
            if (!this.open) {
                this.checkPoint.trigger("before");
                this.checkPoint.awaitStrict("after", 30L, TimeUnit.SECONDS);
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }

        public final void awaitCommandBlock() throws TimeoutException, InterruptedException {
            this.checkPoint.awaitStrict("before", 30L, TimeUnit.SECONDS);
        }

        public final void unblockCommand() {
            this.checkPoint.trigger("after");
        }

        public final void reset() {
            this.open = true;
            this.checkPoint = new CheckPoint();
        }
    }
}

