/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import org.infinispan.Cache;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.distribution.groups.GroupedKey;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.GroupsChFunctionalTest")
@CleanupAfterMethod
public class GroupsChFunctionalTest
extends DistSyncFuncTest {
    public GroupsChFunctionalTest() {
        this.groupers = true;
    }

    public void testGrouper() throws Throwable {
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Assert.assertNotSame(this.getOwners("k1"), this.getOwners("k2"));
        Assert.assertNotSame(this.getOwners("k1"), this.getOwners("k4"));
        Assert.assertNotSame(this.getOwners("k3"), this.getOwners("k2"));
        Assert.assertNotSame(this.getOwners("k3"), this.getOwners("k4"));
        Assert.assertEquals((Object[])this.getOwners("k1"), (Object[])this.getOwners("k3"));
        Assert.assertEquals((Object[])this.getOwners("k2"), (Object[])this.getOwners("k4"));
    }

    public void testIntrinsicGrouping() throws Throwable {
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        GroupedKey k1 = new GroupedKey("groupA", "k1");
        GroupedKey k2 = new GroupedKey("groupB", "k2");
        GroupedKey k3 = new GroupedKey("groupA", "k3");
        GroupedKey k4 = new GroupedKey("groupB", "k4");
        Assert.assertNotSame(this.getOwners(k1), this.getOwners(k2));
        Assert.assertNotSame(this.getOwners(k1), this.getOwners(k4));
        Assert.assertNotSame(this.getOwners(k3), this.getOwners(k2));
        Assert.assertNotSame(this.getOwners(k3), this.getOwners(k4));
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k3));
        Assert.assertEquals((Object[])this.getOwners(k2), (Object[])this.getOwners(k4));
        GroupedKey k1A = new GroupedKey("groupA", "k1");
        GroupedKey k1B = new GroupedKey("groupB", "k1");
        Assert.assertNotSame(this.getOwners(k1A), this.getOwners(k1B));
    }

    public void testRehash() throws Throwable {
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        GroupedKey k1 = new GroupedKey("groupA", "k1");
        GroupedKey k2 = new GroupedKey("groupA", "k2");
        GroupedKey k3 = new GroupedKey("groupA", "k3");
        GroupedKey k4 = new GroupedKey("groupA", "k4");
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k2));
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k3));
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k4));
        Cache<K, V>[] owners1 = this.getOwners(k1);
        Cache<K, V>[] owners2 = this.getOwners(k2);
        Cache<K, V>[] owners3 = this.getOwners(k3);
        Cache<K, V>[] owners4 = this.getOwners(k4);
        Cache owner = this.getOwners("groupA")[0];
        int ownerIndex = -1;
        for (int i = 0; i < this.caches.size(); ++i) {
            if (owner != this.caches.get(i)) continue;
            ownerIndex = i;
            break;
        }
        assert (ownerIndex != -1);
        TestingUtil.killCacheManagers(this.manager(ownerIndex));
        this.caches.remove(ownerIndex);
        this.cacheManagers.remove(ownerIndex);
        TestingUtil.waitForNoRebalance(this.caches);
        Assert.assertNotSame(this.getOwners(k1), owners1);
        Assert.assertNotSame(this.getOwners(k2), owners2);
        Assert.assertNotSame(this.getOwners(k3), owners3);
        Assert.assertNotSame(this.getOwners(k4), owners4);
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k2));
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k3));
        Assert.assertEquals((Object[])this.getOwners(k1), (Object[])this.getOwners(k4));
    }
}

