/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.ScatteredConsistentHash;
import org.infinispan.distribution.groups.BaseUtilGroupTest;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.StateTransferGetGroupKeysTest")
public class StateTransferGetGroupKeysTest
extends BaseUtilGroupTest {
    @Override
    public Object[] factory() {
        return new Object[]{new StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER), new StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.BACKUP_OWNER), new StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.NON_OWNER), new StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER).cacheMode(CacheMode.SCATTERED_SYNC), new StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.NON_OWNER).cacheMode(CacheMode.SCATTERED_SYNC)};
    }

    public StateTransferGetGroupKeysTest() {
        super(null);
    }

    protected StateTransferGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory factory) {
        super(factory);
    }

    public void testGetGroupKeysDuringPrimaryOwnerChange() throws TimeoutException, InterruptedException, ExecutionException {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        StateTransferGetGroupKeysTest.initCache(testCache.primaryOwner);
        BlockCommandInterceptor interceptor = StateTransferGetGroupKeysTest.injectBlockCommandInterceptorIfAbsent(StateTransferGetGroupKeysTest.extractTargetCache(testCache));
        interceptor.open = false;
        Future<Map> future = this.fork(() -> testCache.testCache.getGroup("test-group"));
        interceptor.awaitCommandBlock();
        this.addClusterEnabledCacheManager(BaseUtilGroupTest.GroupTestsSCI.INSTANCE, this.createConfigurationBuilder());
        this.waitForClusterToForm();
        interceptor.unblockCommandAndOpen();
        Map groupKeySet = future.get();
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = StateTransferGetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        super.clearContent();
        if (this.cleanupAfterTest()) {
            while (this.getCacheManagers().size() > 3) {
                this.killMember(3);
            }
            while (this.getCacheManagers().size() < 3) {
                this.addClusterEnabledCacheManager(BaseUtilGroupTest.GroupTestsSCI.INSTANCE, this.createConfigurationBuilder());
            }
            this.waitForClusterToForm();
        }
    }

    @Override
    protected final void resetCaches(List<Cache<BaseUtilGroupTest.GroupKey, String>> cacheList) {
        for (Cache<BaseUtilGroupTest.GroupKey, String> cache : cacheList) {
            AsyncInterceptorChain chain = cache.getAdvancedCache().getAsyncInterceptorChain();
            BlockCommandInterceptor interceptor = (BlockCommandInterceptor)chain.findInterceptorWithClass(BlockCommandInterceptor.class);
            if (interceptor == null) continue;
            interceptor.reset();
        }
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, BaseUtilGroupTest.GroupTestsSCI.INSTANCE, this.createConfigurationBuilder());
    }

    private static BlockCommandInterceptor injectBlockCommandInterceptorIfAbsent(Cache<BaseUtilGroupTest.GroupKey, String> cache) {
        AsyncInterceptorChain chain = cache.getAdvancedCache().getAsyncInterceptorChain();
        BlockCommandInterceptor interceptor = (BlockCommandInterceptor)chain.findInterceptorWithClass(BlockCommandInterceptor.class);
        if (interceptor == null) {
            interceptor = new BlockCommandInterceptor();
            EntryWrappingInterceptor ewi = (EntryWrappingInterceptor)chain.findInterceptorExtending(EntryWrappingInterceptor.class);
            AssertJUnit.assertNotNull((Object)ewi);
            chain.addInterceptorAfter((AsyncInterceptor)interceptor, ewi.getClass());
        }
        interceptor.reset();
        return interceptor;
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = StateTransferGetGroupKeysTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        builder.clustering().stateTransfer().fetchInMemoryState(true);
        builder.clustering().hash().groups().enabled(true);
        builder.clustering().hash().numSegments(1);
        if (this.cacheMode.isScattered()) {
            builder.clustering().hash().consistentHashFactory(new CustomConsistentHashFactory<ScatteredConsistentHash>(new BaseControlledConsistentHashFactory.ScatteredTrait(), this.cacheMode));
        } else {
            CustomConsistentHashFactory<DefaultConsistentHash> chf = new CustomConsistentHashFactory<DefaultConsistentHash>(new BaseControlledConsistentHashFactory.DefaultTrait(), this.cacheMode);
            builder.clustering().hash().consistentHashFactory(chf);
        }
        return builder;
    }

    static class BlockCommandInterceptor
    extends DDAsyncInterceptor {
        private volatile CheckPoint checkPoint = new CheckPoint();
        private volatile boolean open;

        private BlockCommandInterceptor() {
        }

        public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
            if (!this.open) {
                this.checkPoint.trigger("before");
                this.checkPoint.awaitStrict("after", 30L, TimeUnit.SECONDS);
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }

        public final void awaitCommandBlock() throws TimeoutException, InterruptedException {
            this.checkPoint.awaitStrict("before", 30L, TimeUnit.SECONDS);
        }

        public final void unblockCommand() {
            this.checkPoint.trigger("after");
        }

        public final void unblockCommandAndOpen() {
            this.open = true;
            this.checkPoint.trigger("after");
        }

        public final void reset() {
            this.open = true;
            this.checkPoint = new CheckPoint();
        }
    }

    public static class CustomConsistentHashFactory<CH extends ConsistentHash>
    extends BaseControlledConsistentHashFactory<CH> {
        @ProtoField(value=2)
        CacheMode cacheMode;

        CustomConsistentHashFactory() {
        }

        CustomConsistentHashFactory(BaseControlledConsistentHashFactory.Trait<CH> trait, CacheMode cacheMode) {
            super(trait, 1);
            this.cacheMode = cacheMode;
        }

        @Override
        protected int[][] assignOwners(int numSegments, List<Address> members) {
            if (this.cacheMode.isDistributed()) {
                switch (members.size()) {
                    case 1: {
                        return new int[][]{{0}};
                    }
                    case 2: {
                        return new int[][]{{0, 1}};
                    }
                }
                return new int[][]{{members.size() - 1, 0}};
            }
            if (this.cacheMode.isScattered()) {
                return new int[][]{{0}};
            }
            throw new IllegalStateException();
        }
    }
}

