/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.distribution.groups.BaseUtilGroupTest;
import org.infinispan.distribution.groups.TransactionalGetGroupKeysTest;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.WriteSkewGetGroupKeysTest")
public class WriteSkewGetGroupKeysTest
extends TransactionalGetGroupKeysTest {
    @Override
    public Object[] factory() {
        return new Object[]{new WriteSkewGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER), new WriteSkewGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.BACKUP_OWNER), new WriteSkewGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory.NON_OWNER)};
    }

    public WriteSkewGetGroupKeysTest() {
        super(null);
    }

    public WriteSkewGetGroupKeysTest(BaseUtilGroupTest.TestCacheFactory factory) {
        super(factory);
        this.isolationLevel = IsolationLevel.REPEATABLE_READ;
    }

    public void testRemoveGroupWithConcurrentConflictingUpdate() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        WriteSkewGetGroupKeysTest.initCache(testCache.primaryOwner);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 10);
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.primaryOwner.put((Object)WriteSkewGetGroupKeysTest.key(1), (Object)WriteSkewGetGroupKeysTest.value(-1));
        tm.resume(tx);
        try {
            testCache.testCache.removeGroup("test-group");
            groupKeySet = testCache.testCache.getGroup("test-group");
            expectedGroupSet.clear();
            AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
            WriteSkewGetGroupKeysTest.assertCommitFail(tm);
        }
        catch (WriteSkewException e) {
            tm.rollback();
        }
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 10);
        expectedGroupSet.put(WriteSkewGetGroupKeysTest.key(1), WriteSkewGetGroupKeysTest.value(-1));
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testRemoveGroupWithConcurrentAdd() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        WriteSkewGetGroupKeysTest.initCache(testCache.primaryOwner);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 10);
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.primaryOwner.put((Object)WriteSkewGetGroupKeysTest.key(11), (Object)WriteSkewGetGroupKeysTest.value(11));
        tm.resume(tx);
        testCache.testCache.removeGroup("test-group");
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet.clear();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        WriteSkewGetGroupKeysTest.assertCommitOk(tm);
        groupKeySet = testCache.testCache.getGroup("test-group");
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testRemoveGroupWithConcurrentConflictingRemove() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        WriteSkewGetGroupKeysTest.initCache(testCache.primaryOwner);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 10);
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.primaryOwner.remove((Object)WriteSkewGetGroupKeysTest.key(9));
        tm.resume(tx);
        testCache.testCache.removeGroup("test-group");
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet.clear();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        WriteSkewGetGroupKeysTest.assertCommitFail(tm);
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 9);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testRemoveGroupWithConcurrentRemove() throws Exception {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        WriteSkewGetGroupKeysTest.initCache(testCache.primaryOwner);
        TransactionManager tm = this.tm((Cache<?, ?>)testCache.testCache);
        tm.begin();
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = WriteSkewGetGroupKeysTest.createMap(0, 10);
        Transaction tx = tm.suspend();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.primaryOwner.put((Object)WriteSkewGetGroupKeysTest.key(11), (Object)WriteSkewGetGroupKeysTest.value(11));
        testCache.primaryOwner.put((Object)WriteSkewGetGroupKeysTest.key(12), (Object)WriteSkewGetGroupKeysTest.value(12));
        testCache.primaryOwner.remove((Object)WriteSkewGetGroupKeysTest.key(12));
        tm.resume(tx);
        testCache.testCache.removeGroup("test-group");
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet.clear();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        WriteSkewGetGroupKeysTest.assertCommitOk(tm);
        groupKeySet = testCache.testCache.getGroup("test-group");
        expectedGroupSet.clear();
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    private static void assertCommitFail(TransactionManager tm) throws SystemException {
        try {
            tm.commit();
            AssertJUnit.fail((String)"Commit should fail!");
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException throwable) {
            // empty catch block
        }
    }

    private static void assertCommitOk(TransactionManager tm) throws Exception {
        tm.commit();
    }
}

