/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.L1Manager;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.L1StateTransferRemovesValueTest")
public class L1StateTransferRemovesValueTest
extends BaseDistFunctionalTest<String, String> {
    private final String key = this.getClass() + "-key";
    private final String startValue = "starting-value";
    private final String newValue = "new-value";
    protected final ControlledConsistentHashFactory factory = new ControlledConsistentHashFactory.Default(0, 1);

    public L1StateTransferRemovesValueTest() {
        this.INIT_CLUSTER_SIZE = 3;
        this.numOwners = 2;
        this.performRehashing = true;
        this.l1CacheEnabled = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @AfterMethod
    public void resetFactory() {
        this.factory.setOwnerIndexes(0, 1);
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = super.buildConfiguration();
        builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)this.factory).numSegments(1);
        return builder;
    }

    @Test
    public void testStateTransferWithRequestorsForNonExistentL1Value() throws Exception {
        L1Manager l1Manager = TestingUtil.extractComponent(this.c1, L1Manager.class);
        l1Manager.addRequestor((Object)this.key, this.c3.getCacheManager().getAddress());
        Assert.assertNull((Object)this.c3.get((Object)this.key));
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilToplogyInstalled(this.c3, checkPoint);
        this.waitUntilBeforeTopologyInstalled(this.c1, checkPoint);
        this.waitUntilBeforeTopologyInstalled(this.c2, checkPoint);
        this.factory.setOwnerIndexes(0, 2);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(this.cacheName, this.configuration.build());
        Future<Void> join = this.fork(() -> {
            this.waitForClusterToForm(this.cacheName);
            log.debug((Object)"4th has joined");
            return null;
        });
        checkPoint.awaitStrict("post_topology_installed_invoked_" + this.c3, 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("pre_topology_installed_invoked_" + this.c1, 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("pre_topology_installed_invoked_" + this.c2, 10L, TimeUnit.SECONDS);
        Assert.assertNull((Object)this.c1.put((Object)this.key, (Object)"new-value"));
        checkPoint.triggerForever("post_topology_installed_released_" + this.c3);
        checkPoint.triggerForever("pre_topology_installed_released_" + this.c1);
        checkPoint.triggerForever("pre_topology_installed_released_" + this.c2);
        join.get(10L, TimeUnit.SECONDS);
        this.assertIsInContainerImmortal(this.c1, this.key);
        this.assertIsNotInL1(this.c2, this.key);
        this.assertIsInContainerImmortal(this.c3, this.key);
        this.assertIsNotInL1(cm.getCache(this.cacheName), this.key);
        Assert.assertTrue((boolean)DistributionTestHelper.isOwner(this.c1, this.key));
        Assert.assertFalse((boolean)DistributionTestHelper.isOwner(this.c2, this.key));
        Assert.assertTrue((boolean)DistributionTestHelper.isOwner(this.c3, this.key));
        Assert.assertFalse((boolean)DistributionTestHelper.isOwner(cm.getCache(this.cacheName), this.key));
    }

    @Test(groups={"unstable"})
    public void testStateTransferWithL1InvalidationAboutToBeCommitted() throws Exception {
        this.c1.put((Object)this.key, (Object)"starting-value");
        Assert.assertEquals((String)"starting-value", (String)((String)this.c3.get((Object)this.key)));
        this.assertIsInL1(this.c3, this.key);
        CyclicBarrier barrier = new CyclicBarrier(2);
        TestingUtil.extractInterceptorChain(this.c3).addInterceptorAfter(new BlockingInterceptor<InvalidateL1Command>(barrier, InvalidateL1Command.class, true, false), EntryWrappingInterceptor.class);
        CompletableFuture future = this.c1.putAsync((Object)this.key, (Object)"new-value");
        barrier.await(10L, TimeUnit.SECONDS);
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilToplogyInstalled(this.c3, checkPoint);
        this.waitUntilBeforeTopologyInstalled(this.c1, checkPoint);
        this.waitUntilBeforeTopologyInstalled(this.c2, checkPoint);
        this.factory.setOwnerIndexes(0, 2);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(this.cacheName, this.configuration.build());
        Future<Void> join = this.fork(() -> {
            this.waitForClusterToForm(this.cacheName);
            log.debug((Object)"4th has joined");
            return null;
        });
        checkPoint.awaitStrict("post_topology_installed_invoked_" + this.c3, 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("pre_topology_installed_invoked_" + this.c1, 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("pre_topology_installed_invoked_" + this.c2, 10L, TimeUnit.SECONDS);
        barrier.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"starting-value", (String)((String)future.get(10L, TimeUnit.SECONDS)));
        checkPoint.triggerForever("post_topology_installed_released_" + this.c3);
        checkPoint.triggerForever("pre_topology_installed_released_" + this.c1);
        checkPoint.triggerForever("pre_topology_installed_released_" + this.c2);
        join.get(10L, TimeUnit.SECONDS);
        this.assertIsInContainerImmortal(this.c1, this.key);
        this.assertIsNotInL1(this.c2, this.key);
        this.assertIsInContainerImmortal(this.c3, this.key);
        this.assertIsNotInL1(cm.getCache(this.cacheName), this.key);
        Assert.assertTrue((boolean)DistributionTestHelper.isOwner(this.c1, this.key));
        Assert.assertFalse((boolean)DistributionTestHelper.isOwner(this.c2, this.key));
        Assert.assertTrue((boolean)DistributionTestHelper.isOwner(this.c3, this.key));
        Assert.assertFalse((boolean)DistributionTestHelper.isOwner(cm.getCache(this.cacheName), this.key));
    }

    protected void waitUntilBeforeTopologyInstalled(Cache<?, ?> cache, CheckPoint checkPoint) {
        StateConsumer sc = TestingUtil.extractComponent(cache, StateConsumer.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)sc);
        StateConsumer mockConsumer = (StateConsumer)Mockito.mock(StateConsumer.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((StateConsumer)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_topology_installed_invoked_" + cache);
            checkPoint.awaitStrict("pre_topology_installed_released_" + cache, 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockConsumer)).onTopologyUpdate((CacheTopology)ArgumentMatchers.any(CacheTopology.class), ArgumentMatchers.anyBoolean());
        TestingUtil.replaceComponent(cache, StateConsumer.class, mockConsumer, true);
    }

    protected void waitUntilToplogyInstalled(Cache<?, ?> cache, CheckPoint checkPoint) {
        StateTransferLock sc = TestingUtil.extractComponent(cache, StateTransferLock.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)sc);
        StateTransferLock mockConsumer = (StateTransferLock)Mockito.mock(StateTransferLock.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((StateTransferLock)Mockito.doAnswer(invocation -> {
            Object answer = forwardedAnswer.answer(invocation);
            checkPoint.trigger("post_topology_installed_invoked_" + cache);
            checkPoint.awaitStrict("post_topology_installed_released_" + cache, 10L, TimeUnit.SECONDS);
            return answer;
        }).when((Object)mockConsumer)).notifyTopologyInstalled(ArgumentMatchers.anyInt());
        TestingUtil.replaceComponent(cache, StateTransferLock.class, mockConsumer, true);
    }
}

