/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.op.TestOperation;
import org.infinispan.test.op.TestWriteOperation;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxJoinerBecomingBackupOwnerTest")
@CleanupAfterMethod
public class NonTxJoinerBecomingBackupOwnerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, this.getConfigurationBuilder(), 2);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testBackupOwnerJoiningDuringPut() throws Exception {
        this.doTest(TestWriteOperation.PUT_CREATE);
    }

    public void testBackupOwnerJoiningDuringPutIfAbsent() throws Exception {
        this.doTest(TestWriteOperation.PUT_IF_ABSENT);
    }

    public void testBackupOwnerJoiningDuringReplace() throws Exception {
        this.doTest(TestWriteOperation.REPLACE);
    }

    public void testBackupOwnerJoiningDuringReplaceWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REPLACE_EXACT);
    }

    public void testBackupOwnerJoiningDuringRemove() throws Exception {
        this.doTest(TestWriteOperation.REMOVE);
    }

    public void testBackupOwnerJoiningDuringRemoveWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REMOVE_EXACT);
    }

    protected void doTest(TestOperation op) throws Exception {
        StateSequencer sequencer = new StateSequencer();
        sequencer.logicalThread("st", "st:cache0_before_send_state", new String[0]);
        sequencer.logicalThread("write", "write:before_start", "write:start", "write:cache1_before_return", "write:cache2_before_dist", "write:end", "write:after_end");
        sequencer.logicalThread("remote_get_cache0", "remote_get_cache0", new String[0]);
        sequencer.logicalThread("remote_get_cache1", "remote_get_cache1", new String[0]);
        sequencer.order("write:end", "remote_get_cache0", new String[0]).order("write:end", "remote_get_cache1", new String[0]);
        sequencer.action("st:cache0_before_send_state", () -> {
            sequencer.advance("write:before_start");
            sequencer.advance("write:after_end");
            return null;
        });
        AdvancedCache cache0 = this.advancedCache(0);
        AdvancedCache cache1 = this.advancedCache(1);
        StateSequencerUtil.advanceOnOutboundRpc(sequencer, cache0, StateSequencerUtil.matchCommand(StateResponseCommand.class).build()).before("st:cache0_before_send_state", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, cache0, StateTransferInterceptor.class, StateSequencerUtil.matchCommand(GetKeyValueCommand.class).build()).before("remote_get_cache0", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, cache1, StateTransferInterceptor.class, StateSequencerUtil.matchCommand(GetKeyValueCommand.class).build()).before("remote_get_cache1", new String[0]);
        ConfigurationBuilder c = this.getConfigurationBuilder();
        c.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, c);
        log.tracef("Starting the cache on the joiner", new Object[0]);
        AdvancedCache cache2 = this.advancedCache(2);
        this.eventually(() -> cache0.getRpcManager().getMembers().size() == 3 && cache1.getRpcManager().getMembers().size() == 3 && cache2.getRpcManager().getMembers().size() == 3);
        CommandMatcher writeCommandMatcher = StateSequencerUtil.matchCommand(op.getCommandClass()).build();
        StateSequencerUtil.advanceOnInterceptor(sequencer, cache1, StateTransferInterceptor.class, writeCommandMatcher).before("write:cache1_before_return", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, cache2, StateTransferInterceptor.class, writeCommandMatcher).before("write:cache2_before_dist", new String[0]);
        sequencer.advance("write:start");
        MagicKey key = this.getKeyForCache2();
        if (op.getPreviousValue() != null) {
            cache0.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, op.getPreviousValue());
            cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, op.getPreviousValue());
        }
        log.tracef("Initial value set, %s = %s", (Object)key, op.getPreviousValue());
        Future<Object> future = this.fork(() -> op.perform((AdvancedCache<Object, Object>)cache0, key));
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)result);
        log.tracef("%s operation is done", (Object)op);
        sequencer.advance("write:end");
        TestingUtil.waitForNoRebalance(new Cache[]{cache0, cache1, cache2});
        sequencer.stop();
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache0.get((Object)key));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache2.get((Object)key));
    }

    private MagicKey getKeyForCache2() {
        return new MagicKey(this.cache(0), this.cache(1), this.cache(2));
    }
}

