/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxPutIfAbsentDuringLeaveStressTest")
@CleanupAfterMethod
public class NonTxPutIfAbsentDuringLeaveStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_WRITERS = 4;
    private static final int NUM_ORIGINATORS = 2;
    private static final int NUM_KEYS = 100;

    @Override
    public Object[] factory() {
        return new Object[]{new NonTxPutIfAbsentDuringLeaveStressTest().cacheMode(CacheMode.DIST_SYNC), new NonTxPutIfAbsentDuringLeaveStressTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.NEVER), new NonTxPutIfAbsentDuringLeaveStressTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = NonTxPutIfAbsentDuringLeaveStressTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    @Test(groups={"unstable"}, description="ISPN-7682")
    public void testNodeLeavingDuringPutIfAbsent() throws Exception {
        int i;
        final ConcurrentHashMap insertedValues = new ConcurrentHashMap();
        final AtomicBoolean stop = new AtomicBoolean(false);
        Future[] futures = new Future[4];
        for (i = 0; i < 4; ++i) {
            final int writerIndex = i;
            futures[i] = this.fork(new Callable(){

                public Object call() throws Exception {
                    while (!stop.get()) {
                        for (int j = 0; j < 100; ++j) {
                            Cache cache = NonTxPutIfAbsentDuringLeaveStressTest.this.cache(writerIndex % 2);
                            this.doPut((Cache<Object, Object>)cache, "key_" + j, "value_" + j + "_" + writerIndex);
                        }
                    }
                    return null;
                }

                private void doPut(Cache<Object, Object> cache, String key, String value) {
                    Object oldValue = cache.putIfAbsent((Object)key, (Object)value);
                    Object newValue = cache.get((Object)key);
                    if (oldValue == null) {
                        log.tracef("Successfully inserted value %s for key %s", (Object)value, (Object)key);
                        AssertJUnit.assertEquals((Object)value, (Object)newValue);
                        String duplicateInsertedValue = insertedValues.putIfAbsent(key, value);
                        if (duplicateInsertedValue != null) {
                            AssertJUnit.assertEquals((String)value, (String)duplicateInsertedValue);
                        }
                    } else if (newValue == null) {
                        NonTxPutIfAbsentDuringLeaveStressTest.this.eventuallyEquals(oldValue, () -> cache.get((Object)key));
                    } else {
                        AssertJUnit.assertEquals((Object)oldValue, (Object)newValue);
                    }
                }
            });
        }
        this.killMember(4);
        TestingUtil.waitForNoRebalance(this.caches());
        this.killMember(3);
        TestingUtil.waitForNoRebalance(this.caches());
        stop.set(true);
        for (i = 0; i < 4; ++i) {
            futures[i].get(10L, TimeUnit.SECONDS);
            for (int j = 0; j < 100; ++j) {
                for (int k = 0; k < this.caches().size(); ++k) {
                    String key = "key_" + j;
                    AssertJUnit.assertEquals(insertedValues.get(key), (Object)this.cache(k).get((Object)key));
                }
            }
        }
    }
}

