/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.PessimisticStateTransferLocksTest")
public class PessimisticStateTransferLocksTest
extends MultipleCacheManagersTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private StateSequencer sequencer;
    private ControlledConsistentHashFactory consistentHashFactory;

    public PessimisticStateTransferLocksTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @AfterMethod(alwaysRun=true)
    public void printSequencerState() {
        log.debugf("Sequencer state: %s", (Object)this.sequencer);
        if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer = null;
        }
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        this.consistentHashFactory = new ControlledConsistentHashFactory.Default(0, 1);
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.clustering().hash().consistentHashFactory((ConsistentHashFactory)this.consistentHashFactory).numSegments(1);
        c.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        c.transaction().lockingMode(LockingMode.PESSIMISTIC);
        return c;
    }

    public void testPutStartedBeforeRebalance() throws Exception {
        this.sequencer = new StateSequencer();
        this.sequencer.logicalThread("tx", "tx:perform_op", "tx:check_locks", "tx:before_commit", "tx:after_commit");
        this.sequencer.logicalThread("rebalance", "rebalance:before_get_tx", "rebalance:after_get_tx", "rebalance:before_confirm", "rebalance:end");
        this.sequencer.order("tx:perform_op", "rebalance:before_get_tx", "rebalance:after_get_tx", "tx:check_locks", "rebalance:before_confirm", "rebalance:end", "tx:before_commit");
        this.startTxWithPut();
        this.startRebalance();
        this.checkLocksBeforeCommit(false);
        this.waitRebalanceEnd();
        this.endTx();
        this.checkLocksAfterCommit();
    }

    public void testLockStartedBeforeRebalance() throws Exception {
        this.sequencer = new StateSequencer();
        this.sequencer.logicalThread("tx", "tx:perform_op", "tx:check_locks", "tx:before_commit", "tx:after_commit");
        this.sequencer.logicalThread("rebalance", "rebalance:before_get_tx", "rebalance:after_get_tx", "rebalance:before_confirm", "rebalance:end");
        this.sequencer.order("tx:perform_op", "rebalance:before_get_tx", "rebalance:after_get_tx", "tx:check_locks", "rebalance:before_confirm", "rebalance:end", "tx:before_commit");
        this.startTxWithLock();
        this.startRebalance();
        this.checkLocksBeforeCommit(false);
        this.waitRebalanceEnd();
        this.endTx();
        this.checkLocksAfterCommit();
    }

    public void testPutStartedDuringRebalance() throws Exception {
        this.sequencer = new StateSequencer();
        this.sequencer.logicalThread("tx", "tx:perform_op", "tx:check_locks", "tx:before_commit", "tx:after_commit");
        this.sequencer.logicalThread("rebalance", "rebalance:before_get_tx", "rebalance:after_get_tx", "rebalance:before_confirm", "rebalance:end");
        this.sequencer.order("rebalance:after_get_tx", "tx:perform_op", "tx:check_locks", "rebalance:before_confirm", "rebalance:end", "tx:before_commit");
        this.startRebalance();
        this.startTxWithPut();
        this.checkLocksBeforeCommit(true);
        this.waitRebalanceEnd();
        this.endTx();
        this.checkLocksAfterCommit();
    }

    public void testLockStartedDuringRebalance() throws Exception {
        this.sequencer = new StateSequencer();
        this.sequencer.logicalThread("tx", "tx:perform_op", "tx:check_locks", "tx:before_commit", "tx:after_commit");
        this.sequencer.logicalThread("rebalance", "rebalance:before_get_tx", "rebalance:after_get_tx", "rebalance:before_confirm", "rebalance:end");
        this.sequencer.order("rebalance:after_get_tx", "tx:perform_op", "tx:check_locks", "rebalance:before_confirm", "rebalance:end", "tx:before_commit");
        this.startRebalance();
        this.startTxWithLock();
        this.checkLocksBeforeCommit(true);
        this.waitRebalanceEnd();
        this.endTx();
        this.checkLocksAfterCommit();
    }

    private void startTxWithPut() throws Exception {
        this.sequencer.enter("tx:perform_op");
        this.tm(0).begin();
        this.cache(0).put((Object)KEY, (Object)VALUE);
        this.sequencer.exit("tx:perform_op");
    }

    private void startTxWithLock() throws Exception {
        this.sequencer.enter("tx:perform_op");
        this.tm(0).begin();
        this.advancedCache(0).lock(new Object[]{KEY});
        this.sequencer.exit("tx:perform_op");
    }

    private void startRebalance() throws Exception {
        InvocationMatcher rebalanceCompletedMatcher = StateSequencerUtil.matchMethodCall("handleRebalancePhaseConfirm").withParam(1, this.address(2)).matchCount(0).build();
        StateSequencerUtil.advanceOnGlobalComponentMethod(this.sequencer, this.manager(0), ClusterTopologyManager.class, rebalanceCompletedMatcher).before("rebalance:before_confirm", new String[0]);
        InvocationMatcher localRebalanceMatcher = StateSequencerUtil.matchMethodCall("onTopologyUpdate").withParam(1, true).matchCount(0).build();
        StateSequencerUtil.advanceOnComponentMethod(this.sequencer, this.cache(2), StateConsumer.class, localRebalanceMatcher).before("rebalance:before_get_tx", new String[0]).afterAsync("rebalance:after_get_tx", new String[0]);
        this.consistentHashFactory.setOwnerIndexes(2, 1);
        this.consistentHashFactory.triggerRebalance(this.cache(0));
    }

    private void waitRebalanceEnd() throws Exception {
        this.sequencer.advance("rebalance:end");
        TestingUtil.waitForNoRebalance(this.caches());
    }

    private void endTx() throws Exception {
        this.sequencer.advance("tx:before_commit");
        this.tm(0).commit();
    }

    private void checkLocksBeforeCommit(boolean backupLockOnCache1) throws Exception {
        this.sequencer.enter("tx:check_locks");
        AssertJUnit.assertFalse((boolean)this.getTransactionTable(this.cache(0)).getLocalTransactions().isEmpty());
        AssertJUnit.assertTrue((boolean)this.getTransactionTable(this.cache(0)).getRemoteTransactions().isEmpty());
        LocalTransaction localTx = (LocalTransaction)this.getTransactionTable(this.cache(0)).getLocalTransactions().iterator().next();
        AssertJUnit.assertEquals(Collections.singleton(KEY), (Object)localTx.getLockedKeys());
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)localTx.getBackupLockedKeys());
        AssertJUnit.assertTrue((boolean)this.getTransactionTable(this.cache(1)).getLocalTransactions().isEmpty());
        AssertJUnit.assertEquals((boolean)backupLockOnCache1, (!this.getTransactionTable(this.cache(1)).getRemoteTransactions().isEmpty() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.getTransactionTable(this.cache(2)).getLocalTransactions().isEmpty());
        AssertJUnit.assertFalse((boolean)this.getTransactionTable(this.cache(2)).getRemoteTransactions().isEmpty());
        RemoteTransaction remoteTx = (RemoteTransaction)this.getTransactionTable(this.cache(2)).getRemoteTransactions().iterator().next();
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)remoteTx.getLockedKeys());
        AssertJUnit.assertEquals(Collections.singleton(KEY), (Object)remoteTx.getBackupLockedKeys());
        this.sequencer.exit("tx:check_locks");
    }

    private void checkLocksAfterCommit() {
        for (Cache c : this.caches()) {
            TransactionTable txTable = this.getTransactionTable(c);
            AssertJUnit.assertTrue((boolean)txTable.getLocalTransactions().isEmpty());
            this.eventuallyEquals(0, () -> txTable.getRemoteTransactions().size());
        }
    }

    private TransactionTable getTransactionTable(Cache<Object, Object> c) {
        return TestingUtil.extractComponent(c, TransactionTable.class);
    }
}

