/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.distribution.group.Group;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.logging.Logger;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="distribution.rehash.RehashStressTest", timeOut=900000L)
public class RehashStressTest
extends AbstractInfinispanTest {
    private static Logger log = Logger.getLogger((String)RehashStressTest.class.getName());
    private static final int KEY_RANGE = 10;
    private static final int TEST_THREADS = 40;
    private static final int TEST_LOOPS = 30000;
    public static final int MAX_INTERVAL_BETWEEN_TASK = 1000;
    LinkedList<EmbeddedCacheManager> cacheManagers = new LinkedList();
    Random random = new Random();

    @AfterMethod
    public void stopAllCacheManageres() {
        while (!this.cacheManagers.isEmpty()) {
            this.cacheManagers.poll().stop();
        }
    }

    public void testRehash() throws IOException, InterruptedException {
        int i;
        EmbeddedCacheManager cacheManager = this.buildCacheManager();
        this.cacheManagers.addLast(cacheManager);
        cacheManager.getCache("serviceGroup");
        new AddNodeTask().run();
        new AddNodeTask().run();
        new AddNodeTask().run();
        Thread.sleep(3000L);
        log.info((Object)"Start testing");
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(40);
        executor.prestartAllCoreThreads();
        for (i = 0; i < 30000; ++i) {
            executor.submit(new SimulateTask());
        }
        for (i = 0; i < 10; ++i) {
            try {
                Thread.sleep(3000L);
                if (i != 1) {
                    new AddNodeTask().run();
                    continue;
                }
                new RemoveNodeTask().run();
                continue;
            }
            catch (RuntimeException e) {
                log.warn((Object)"Error during add/remove node", (Throwable)e);
            }
        }
        log.info((Object)"Rehash phase is completed...");
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
    }

    private EmbeddedCacheManager buildCacheManager() throws IOException {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml("erm-cluster.xml");
        return cacheManager;
    }

    class AddNodeTask
    implements Runnable {
        AddNodeTask() {
        }

        @Override
        public void run() {
            try {
                log.info((Object)"Starting a new cache manager");
                EmbeddedCacheManager cacheManager = RehashStressTest.this.buildCacheManager();
                cacheManager.getCache("serviceGroup");
                RehashStressTest.this.cacheManagers.addLast(cacheManager);
            }
            catch (Exception e) {
                log.warn((Object)"Error during node addition", (Throwable)e);
            }
        }
    }

    class RemoveNodeTask
    implements Runnable {
        RemoveNodeTask() {
        }

        @Override
        public void run() {
            try {
                int size = RehashStressTest.this.cacheManagers.size();
                int index = RehashStressTest.this.random.nextInt(size);
                EmbeddedCacheManager cacheManager = RehashStressTest.this.cacheManagers.remove(index);
                log.info((Object)("Shutting down " + cacheManager.getAddress()));
                cacheManager.stop();
                log.info((Object)("Shut down " + cacheManager.getAddress() + " complete"));
            }
            catch (Exception e) {
                log.warn((Object)"Error during node removal", (Throwable)e);
            }
        }
    }

    static class TransactionTask
    implements Function<EmbeddedCacheManager, String>,
    Serializable {
        private final String cacheName;
        private final TestKey key;

        TransactionTask(String cacheName, TestKey key) {
            this.cacheName = cacheName;
            this.key = key;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String apply(EmbeddedCacheManager embeddedCacheManager) {
            try {
                Cache cache = embeddedCacheManager.getCache(this.cacheName);
                TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
                try {
                    tm.begin();
                    String string = this.performWork(cache);
                    return string;
                }
                catch (Exception e) {
                    log.warn((Object)("error during perform work " + this.key), (Throwable)e);
                    tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    int status = -1;
                    try {
                        status = tm.getStatus();
                    }
                    catch (Exception exception) {}
                    if (status == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                }
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }

        private String performWork(Cache<TestKey, ?> cache) {
            log.info((Object)("Locking " + this.key));
            cache.getAdvancedCache().lock((Object[])new TestKey[]{this.key});
            return "locked " + this.key;
        }
    }

    class SimulateTask
    implements Runnable {
        SimulateTask() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(RehashStressTest.this.random.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TestKey key = new TestKey(RehashStressTest.this.random.nextInt(10));
            try {
                log.info((Object)("Submitting a task " + key));
                EmbeddedCacheManager cacheManager = RehashStressTest.this.cacheManagers.get(RehashStressTest.this.random.nextInt(RehashStressTest.this.cacheManagers.size()));
                ClusterExecutor executor = cacheManager.executor();
                AtomicReference value = new AtomicReference();
                CompletableFuture future = executor.submitConsumer((Function)new TransactionTask("serviceGroup", key), (a, v, t) -> {
                    if (t != null) {
                        throw new CacheException(t);
                    }
                    value.set(v);
                });
                log.info((Object)("Task result=" + (String)((CompletableFuture)future.thenApply(ignore -> (String)value.get())).get()));
            }
            catch (Exception ex) {
                log.warn((Object)("error during executing task " + key), (Throwable)ex);
            }
        }
    }

    static class TestKey
    implements Serializable {
        int key;

        @Group
        public String getGroup() {
            return String.valueOf(this.key);
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public TestKey(int key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestKey other = (TestKey)obj;
            return this.key == other.key;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.key;
            return hash;
        }

        public String toString() {
            return "TestKey{key=" + this.key + '}';
        }
    }
}

