/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="distribution.rehash.RehashWithSharedStoreTest", groups={"functional"})
public class RehashWithSharedStoreTest
extends BaseDistStoreTest<Object, String, RehashWithSharedStoreTest> {
    private static final Log log = LogFactory.getLog(RehashWithSharedStoreTest.class);

    @Override
    public Object[] factory() {
        return new Object[]{new RehashWithSharedStoreTest().segmented(false), new RehashWithSharedStoreTest().segmented(true), ((RehashWithSharedStoreTest)new RehashWithSharedStoreTest().segmented(false)).numOwners(1).l1(false).cacheMode(CacheMode.SCATTERED_SYNC).transactional(false), ((RehashWithSharedStoreTest)new RehashWithSharedStoreTest().segmented(true)).numOwners(1).l1(false).cacheMode(CacheMode.SCATTERED_SYNC).transactional(false)};
    }

    public RehashWithSharedStoreTest() {
        this.INIT_CLUSTER_SIZE = 3;
        this.testRetVals = true;
        this.performRehashing = true;
        this.shared = true;
    }

    @BeforeMethod
    public void afterMethod() {
        this.clearStats(this.c1);
    }

    public void testRehashes() throws PersistenceException {
        int numWrites;
        MagicKey k = new MagicKey("k", this.c1);
        this.c1.put((Object)k, (Object)"v");
        Cache<K, V>[] owners = this.getOwners(k);
        log.infof("Initial owners list for key %s: %s", (Object)k, Arrays.asList(owners));
        for (Cache c : Arrays.asList(this.c1, this.c2, this.c3)) {
            DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            AssertJUnit.assertTrue((String)("CacheStore on " + c + " should contain key " + k), (boolean)dims.contains(k));
        }
        Cache primaryOwner = owners[0];
        if (this.getCacheStoreStats(primaryOwner, "write") == 0) {
            primaryOwner = owners[1];
        }
        for (Cache c : owners) {
            numWrites = this.getCacheStoreStats(c, "write");
            AssertJUnit.assertEquals((int)1, (int)numWrites);
        }
        log.infof("Stopping node %s", primaryOwner);
        this.caches.remove(primaryOwner);
        primaryOwner.stop();
        primaryOwner.getCacheManager().stop();
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches);
        TestingUtil.waitForNoRebalance(this.caches);
        owners = this.getOwners(k);
        log.infof("After shutting one node down, owners list for key %s: %s", (Object)k, Arrays.asList(owners));
        AssertJUnit.assertEquals((int)this.numOwners, (int)owners.length);
        for (Cache o : owners) {
            numWrites = this.getCacheStoreStats(o, "write");
            AssertJUnit.assertEquals((int)1, (int)numWrites);
            AssertJUnit.assertEquals((String)"v", (String)((String)o.get((Object)k)));
        }
    }
}

