/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="distribution.rehash.SharedStoreInvalidationDuringRehashTest", groups={"functional"})
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.SCATTERED_SYNC})
public class SharedStoreInvalidationDuringRehashTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(SharedStoreInvalidationDuringRehashTest.class);
    private static final int NUM_KEYS = 20;
    private static final String TEST_CACHE_NAME = "testCache";

    @Override
    protected void createCacheManagers() {
    }

    private void addNewCacheManagerAndWaitForRehash(int index, boolean preload) {
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(SharedStoreInvalidationDuringRehashTest.getDefaultClusteredCacheConfig(this.cacheMode, false));
        Configuration config = this.buildCfg(index, true, preload);
        cacheManager.defineConfiguration(TEST_CACHE_NAME, config);
        log.debugf("\n\nstarted CacheManager #%d", this.getCacheManagers().size() - 1);
        this.waitForClusterToForm(TEST_CACHE_NAME);
    }

    private Configuration buildCfg(int index, boolean clustered, boolean preload) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.persistence().passivation(false);
        DummyInMemoryStoreConfigurationBuilder dummyCB = (DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)dummyCB.preload(preload)).shared(true)).purgeOnStartup(false);
        dummyCB.storeName(SharedStoreInvalidationDuringRehashTest.class.getSimpleName());
        if (clustered) {
            cb.clustering().l1().disable();
            cb.clustering().cacheMode(this.cacheMode);
            cb.clustering().hash().numOwners(1);
            cb.clustering().stateTransfer().fetchInMemoryState(true);
            cb.clustering().hash().groups().enabled();
        }
        return cb.build(true);
    }

    private void incrementCounter(ConcurrentMap<Integer, ConcurrentMap<Object, AtomicInteger>> counterMap, int index, Object[] keys) {
        ConcurrentMap counters = counterMap.computeIfAbsent(index, ignored -> new ConcurrentHashMap());
        for (Object key : keys) {
            counters.computeIfAbsent(key, k -> new AtomicInteger()).incrementAndGet();
        }
    }

    private int getCounter(ConcurrentMap<Integer, ConcurrentMap<Object, AtomicInteger>> counterMap, int index) {
        ConcurrentMap counters = (ConcurrentMap)counterMap.get(index);
        return counters == null ? 0 : counters.values().stream().mapToInt(AtomicInteger::get).sum();
    }

    private int getSum(ConcurrentMap<Integer, ConcurrentMap<Object, AtomicInteger>> counterMap) {
        return counterMap.values().stream().flatMapToInt(m -> m.values().stream().mapToInt(AtomicInteger::get)).sum();
    }

    public void testRehashWithPreload() {
        this.doTest(true);
    }

    public void testRehashWithoutPreload() {
        this.doTest(false);
    }

    private void doTest(boolean preload) {
        this.addNewCacheManagerAndWaitForRehash(0, preload);
        this.insertTestData();
        this.printCacheContents();
        this.printStoreContents();
        this.checkContentAndInvalidations(preload);
        this.killMember(0);
        this.addNewCacheManagerAndWaitForRehash(0, preload);
        this.printCacheContents();
        this.printStoreContents();
        this.checkContentAndInvalidations(preload);
        this.addNewCacheManagerAndWaitForRehash(1, preload);
        this.printCacheContents();
        this.printStoreContents();
        this.checkContentAndInvalidations(preload);
        this.addNewCacheManagerAndWaitForRehash(2, preload);
        this.printCacheContents();
        this.printStoreContents();
        this.checkContentAndInvalidations(preload);
    }

    private void insertTestData() {
        Cache cache = this.manager(0).getCache(TEST_CACHE_NAME);
        for (int i = 0; i < 20; ++i) {
            cache.put((Object)("key" + i), (Object)Integer.toString(i));
        }
        log.debugf("Added %d entries to test cache", 20);
    }

    private void checkContentAndInvalidations(boolean preload) {
        int clusterSize = this.getCacheManagers().size();
        HashMap<String, Integer> currentOwners = new HashMap<String, Integer>();
        for (int i = 0; i < clusterSize; ++i) {
            Cache testCache = this.manager(i).getCache(TEST_CACHE_NAME);
            DistributionManager dm = testCache.getAdvancedCache().getDistributionManager();
            DataContainer dataContainer = testCache.getAdvancedCache().getDataContainer();
            for (int j = 0; j < 20; ++j) {
                String key = "key" + j;
                if (!dm.getCacheTopology().isReadOwner((Object)key)) {
                    if (this.cacheMode.isScattered()) continue;
                    AssertJUnit.assertFalse((String)("Key '" + key + "' is not owned by node " + this.address(i) + " but it still appears there"), (boolean)dataContainer.containsKey((Object)key));
                    continue;
                }
                currentOwners.put(key, i);
                if (!preload) continue;
                AssertJUnit.assertTrue((String)("Key '" + key + "' is owned by node " + this.address(i) + " but it does not appear there"), (boolean)dataContainer.containsKey((Object)key));
            }
        }
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache(0, TEST_CACHE_NAME));
        for (int i = 0; i < 20; ++i) {
            String key = "key" + i;
            AssertJUnit.assertTrue((String)("Key " + key + " is missing from the shared store"), (boolean)store.keySet().contains(key));
        }
        if (this.cacheMode.isScattered()) {
            return;
        }
        store.clearStats();
    }

    private int computeDiff(Map<Object, Integer> previous, Map<Object, Integer> current) {
        AssertJUnit.assertEquals((int)previous.size(), (int)current.size());
        int diff = 0;
        for (Map.Entry<Object, Integer> pair : previous.entrySet()) {
            if (Integer.compare(pair.getValue(), current.get(pair.getKey())) == 0) continue;
            ++diff;
        }
        return diff;
    }

    private void printCacheContents() {
        log.debugf("%d cache managers: %s", this.getCacheManagers().size(), this.getCacheManagers());
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            Cache testCache = this.manager(i).getCache(TEST_CACHE_NAME);
            DataContainer dataContainer = testCache.getAdvancedCache().getDataContainer();
            log.debugf("DC on %s has %d keys: %s", (Object)this.address(i), (Object)dataContainer.size(), (Object)StreamSupport.stream(dataContainer.spliterator(), false).map(Map.Entry::getKey).collect(Collectors.joining(",")));
            CacheSet keySet = testCache.keySet();
            log.debugf("Cache %s has %d keys: %s", (Object)this.address(i), (Object)keySet.size(), (Object)keySet);
        }
    }

    private void printStoreContents() {
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache(0, TEST_CACHE_NAME));
        Set<Object> keySet = store.keySet();
        log.debugf("Shared store has %d keys: %s", keySet.size(), keySet);
    }
}

