/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.rehash.RehashTestBase;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.SingleJoinTest")
public class SingleJoinTest
extends RehashTestBase {
    EmbeddedCacheManager joinerManager;
    Cache<Object, String> joiner;

    @Override
    void performRehashEvent(boolean offline) {
        this.joinerManager = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE);
        this.joinerManager.defineConfiguration(this.cacheName, this.configuration.build());
        this.joiner = this.joinerManager.getCache(this.cacheName);
    }

    @Override
    void waitForRehashCompletion() {
        ArrayList<Cache<Object, String>> allCaches = new ArrayList<Cache<Object, String>>(this.caches);
        allCaches.add(this.joiner);
        TestingUtil.blockUntilViewsReceived(60000, allCaches);
        this.waitForClusterToForm(this.cacheName);
        this.cacheManagers.add(this.joinerManager);
        this.caches.add(this.joiner);
    }

    @Override
    @Test(groups={"unstable"}, description="ISPN-8276")
    public void testNonTransactional() throws Throwable {
        super.testNonTransactionalStress();
    }
}

