/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.HashMap;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.globalstate.NoOpGlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.BlockingLocalTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.WriteOperationDuringLeaverTest")
@CleanupAfterMethod
public class WriteOperationDuringLeaverTest
extends MultipleCacheManagersTest {
    private static final int NUMBER_NODES = 3;

    public void testSingleKeyCommandWithExistingKey() throws Exception {
        this.doTest(Operation.SINGLE_KEY, true);
    }

    public void testMultipleKeyCommandWithExistingKey() throws Exception {
        this.doTest(Operation.MULTIPLE_KEYS, true);
    }

    public void testSingleKeyCommandWithNewgKey() throws Exception {
        this.doTest(Operation.SINGLE_KEY, false);
    }

    public void testMultipleKeyCommandWithNewKey() throws Exception {
        this.doTest(Operation.MULTIPLE_KEYS, false);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = WriteOperationDuringLeaverTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numOwners(2);
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, builder);
    }

    @Override
    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
        NoOpGlobalConfigurationManager.amendCacheManager(cm);
    }

    private void doTest(Operation operation, boolean init) throws Exception {
        MagicKey key = new MagicKey(this.cache(1), this.cache(2));
        if (init) {
            this.cache(0).put((Object)key, (Object)"v1");
            this.assertInAllCache(key, "v1");
        }
        BlockingLocalTopologyManager bltm0 = BlockingLocalTopologyManager.replaceTopologyManagerDefaultCache(this.manager(0));
        BlockingLocalTopologyManager bltm1 = BlockingLocalTopologyManager.replaceTopologyManagerDefaultCache(this.manager(1));
        this.killMember(2, null, false);
        bltm0.expectRebalanceStartAfterLeave().unblock();
        bltm1.expectRebalanceStartAfterLeave().unblock();
        bltm0.expectPhaseConfirmation().unblock();
        bltm1.expectPhaseConfirmation().unblock();
        LocalizedCacheTopology cacheTopology = TestingUtil.extractComponent(this.cache(0), DistributionManager.class).getCacheTopology();
        DistributionInfo distributionInfo = cacheTopology.getDistribution((Object)key);
        AssertJUnit.assertFalse((boolean)distributionInfo.isReadOwner());
        AssertJUnit.assertTrue((boolean)distributionInfo.isWriteOwner());
        AssertJUnit.assertEquals((Object)this.address(1), (Object)distributionInfo.primary());
        operation.put(key, "v2", this.cache(1));
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, bltm0, bltm1);
        this.waitForClusterToForm();
        this.assertInAllCache(key, "v2");
    }

    private <K, V> void assertInAllCache(K key, V value) {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)("Wrong value in cache " + this.address(cache)), value, (Object)cache.get(key));
        }
    }

    private static class CacheTopologyMatcher
    extends BaseMatcher<Object> {
        private final int topologyId;

        CacheTopologyMatcher(int topologyId) {
            this.topologyId = topologyId;
        }

        public boolean matches(Object item) {
            return item instanceof CacheTopology && ((CacheTopology)item).getTopologyId() == this.topologyId;
        }

        public void describeTo(Description description) {
            description.appendText("CacheTopology(" + this.topologyId + ")");
        }
    }

    private static enum Operation {
        SINGLE_KEY{

            @Override
            <K, V> void put(K key, V value, Cache<K, V> cache) {
                cache.put(key, value);
            }
        }
        ,
        MULTIPLE_KEYS{

            @Override
            <K, V> void put(K key, V value, Cache<K, V> cache) {
                HashMap<K, V> map = new HashMap<K, V>();
                map.put(key, value);
                cache.putAll(map);
            }
        };


        abstract <K, V> void put(K var1, V var2, Cache<K, V> var3);
    }
}

